/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.command.argument;

import com.google.common.collect.Streams;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.configuration.locale.TranslationsConfig;
import dev.jsinco.brewery.event.CustomEvent;
import dev.jsinco.brewery.event.DrunkEvent;
import dev.jsinco.brewery.event.NamedDrunkEvent;
import dev.jsinco.brewery.util.BreweryKey;
import dev.jsinco.brewery.util.MessageUtil;
import dev.jsinco.brewery.util.Registry;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

public class EventArgument
implements CustomArgumentType.Converted<DrunkEvent, String> {
    private static final DynamicCommandExceptionType ERROR_INVALID_EVENT = new DynamicCommandExceptionType(event -> (Message)MessageComponentSerializer.message().serialize(MessageUtil.miniMessage(TranslationsConfig.COMMAND_ILLEGAL_ARGUMENT_DETAILED, new TagResolver[]{Placeholder.unparsed((String)"argument", (String)event.toString())})));

    public DrunkEvent convert(String nativeType) throws CommandSyntaxException {
        BreweryKey key = BreweryKey.parse(nativeType);
        NamedDrunkEvent namedDrunkEvent = Registry.DRUNK_EVENT.get(key);
        if (namedDrunkEvent != null) {
            return namedDrunkEvent;
        }
        CustomEvent.Keyed customEvent = TheBrewingProject.getInstance().getCustomDrunkEventRegistry().getCustomEvent(key);
        if (customEvent != null) {
            return customEvent;
        }
        throw ERROR_INVALID_EVENT.create((Object)nativeType);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, SuggestionsBuilder builder) {
        Stream<CustomEvent.Keyed> customEventStream = TheBrewingProject.getInstance().getCustomDrunkEventRegistry().events().stream();
        Streams.concat((Stream[])new Stream[]{Registry.DRUNK_EVENT.values().stream(), customEventStream}).map(DrunkEvent::key).map(BreweryKey::key).filter(event -> event.startsWith(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.word();
    }
}

