/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.configuration.serializer;

import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import dev.jsinco.brewery.util.Logger;
import dev.jsinco.brewery.vector.BreweryLocation;
import java.util.Arrays;
import java.util.UUID;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.generator.WorldInfo;

public class BreweryLocationSerializer
implements ObjectSerializer<BreweryLocation.Uncompiled> {
    private UUID parseWorld(String worldString) {
        World world;
        try {
            world = Bukkit.getWorld((UUID)UUID.fromString(worldString));
        }
        catch (IllegalArgumentException e) {
            world = Bukkit.getWorld((String)worldString);
        }
        if (world == null) {
            Logger.logErr("Could not find world: " + worldString);
            return null;
        }
        return world.getUID();
    }

    @Override
    public boolean supports(@NonNull Class<? super BreweryLocation.Uncompiled> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return BreweryLocation.Uncompiled.class == type;
    }

    @Override
    public void serialize(@NonNull BreweryLocation.Uncompiled object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        BreweryLocation location = object.get(Bukkit.getWorlds().stream().map(WorldInfo::getUID).toList());
        if (location == null) {
            location = new BreweryLocation(0, 0, 0, UUID.randomUUID());
        }
        World world = Bukkit.getWorld((UUID)location.worldUuid());
        data.setValue(String.format("%s, %d, %d, %d", world == null ? location.worldUuid() : world.getName(), location.x(), location.y(), location.z()));
    }

    @Override
    public BreweryLocation.Uncompiled deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        String string = data.getValue(String.class);
        if (string == null) {
            throw new IllegalArgumentException("Can not deserialize empty node");
        }
        String[] split = (String[])Arrays.stream(string.split(",")).map(String::trim).toArray(String[]::new);
        if (split.length != 4) {
            throw new IllegalArgumentException("Expected location of format world, x, y, z");
        }
        try {
            int x = Integer.parseInt(split[1]);
            int y = Integer.parseInt(split[2]);
            int z = Integer.parseInt(split[3]);
            return ignored -> {
                UUID worldUuid = this.parseWorld(split[0]);
                return worldUuid == null ? null : new BreweryLocation(x, y, z, worldUuid);
            };
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
    }
}

