/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.configuration.serializer;

import dev.jsinco.brewery.bukkit.util.BukkitAdapter;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import dev.jsinco.brewery.util.Holder;
import lombok.NonNull;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;

public class MaterialSerializer
implements ObjectSerializer<Holder.Material> {
    @Override
    public boolean supports(@NonNull Class<? super Holder.Material> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return Holder.Material.class == type;
    }

    @Override
    public void serialize( @NonNull Holder.Material object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        data.setValue(object.value().toString());
    }

    @Override
    public Holder.Material deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        String value = data.getValue(String.class);
        NamespacedKey key = NamespacedKey.fromString((String)value);
        if (key == null) {
            throw new IllegalArgumentException("Invalid key: " + value);
        }
        Material material = (Material)Registry.MATERIAL.get(key);
        if (material == null) {
            throw new IllegalArgumentException("Unknown material key: " + value);
        }
        return new Holder.Material(BukkitAdapter.toBreweryKey(key));
    }
}

