/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.effect.named;

import dev.jsinco.brewery.bukkit.util.BukkitMessageUtil;
import dev.jsinco.brewery.configuration.locale.TranslationsConfig;
import dev.jsinco.brewery.event.EventPropertyExecutable;
import dev.jsinco.brewery.event.EventStep;
import dev.jsinco.brewery.util.MessageUtil;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class ChickenNamedExecutable
implements EventPropertyExecutable {
    public static final NamespacedKey NO_DROPS = new NamespacedKey("brewery", "no_drops");

    @Override
    @NotNull
    public EventPropertyExecutable.ExecutionResult execute(UUID contextPlayer, List<? extends EventStep> events, int index) {
        Player player = Bukkit.getPlayer((UUID)contextPlayer);
        if (player == null) {
            return EventPropertyExecutable.ExecutionResult.CONTINUE;
        }
        player.getWorld().spawn(player.getLocation(), Chicken.class, chicken -> {
            chicken.setEggLayTime(Integer.MAX_VALUE);
            chicken.setPersistent(false);
            chicken.setAge(0);
            chicken.getPersistentDataContainer().set(NO_DROPS, PersistentDataType.BOOLEAN, (Object)true);
            chicken.setBreed(false);
        });
        MessageUtil.message((Audience)player, TranslationsConfig.CHICKEN_MESSAGE, BukkitMessageUtil.getPlayerTagResolver(player));
        return EventPropertyExecutable.ExecutionResult.CONTINUE;
    }

    @Override
    public int priority() {
        return -1;
    }
}

