/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.effect.named;

import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.event.EventPropertyExecutable;
import dev.jsinco.brewery.event.EventStep;
import dev.jsinco.brewery.event.NamedDrunkEvent;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class StumbleNamedExecutable
implements EventPropertyExecutable {
    private static final int STUMBLE_DURATION = 10;

    @Override
    @NotNull
    public EventPropertyExecutable.ExecutionResult execute(UUID contextPlayer, List<? extends EventStep> events, int index) {
        Player player = Bukkit.getPlayer((UUID)contextPlayer);
        if (player == null) {
            return EventPropertyExecutable.ExecutionResult.CONTINUE;
        }
        int duration = RANDOM.nextInt(5, 16);
        StumbleHandler stumbleHandler = new StumbleHandler(duration, player);
        TheBrewingProject.getInstance().getActiveEventsRegistry().registerActiveEvent(player.getUniqueId(), NamedDrunkEvent.fromKey("stumble"), duration);
        player.getScheduler().runAtFixedRate((Plugin)TheBrewingProject.getInstance(), stumbleHandler::tick, () -> {}, 1L, 1L);
        return EventPropertyExecutable.ExecutionResult.CONTINUE;
    }

    @Override
    public int priority() {
        return -1;
    }

    static class StumbleHandler {
        private final Vector pushDirection2;
        private int countDown;
        private final int duration;
        private final Player player;
        private final Vector pushDirection1;
        private static final Random RANDOM = new Random();

        public StumbleHandler(int duration, Player player) {
            this.countDown = duration;
            this.duration = duration;
            this.player = player;
            double radians1 = RANDOM.nextDouble(Math.PI * 2);
            Vector walk = TheBrewingProject.getInstance().getPlayerWalkListener().getRegisteredMovement(player.getUniqueId());
            double maxMagnitude = walk == null ? 0.1 : Math.max(0.1, walk.length());
            this.pushDirection1 = new Vector(Math.cos(radians1), 0.0, Math.sin(radians1)).multiply(RANDOM.nextDouble(maxMagnitude));
            double radians2 = RANDOM.nextDouble(Math.PI * 2);
            this.pushDirection2 = new Vector(Math.cos(radians2), 0.0, Math.sin(radians2)).multiply(RANDOM.nextDouble(maxMagnitude));
        }

        public void tick(ScheduledTask task) {
            if (!this.player.isOnline() || this.countDown-- < 0) {
                task.cancel();
                return;
            }
            if (!this.player.isOnGround()) {
                return;
            }
            double progress = ((double)this.duration - (double)this.countDown) / (double)this.duration;
            Vector pushDirection = this.pushDirection2.clone().multiply(progress).add(this.pushDirection1.clone().multiply(1.0 - progress));
            this.player.setVelocity(pushDirection);
        }
    }
}

