/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.ingredient;

import dev.jsinco.brewery.ingredient.Ingredient;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SimpleIngredient
implements Ingredient {
    private final Material material;

    public SimpleIngredient(Material material) {
        this.material = material;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.material.getKey().toString();
    }

    @Override
    @NotNull
    public Component displayName() {
        String translationKey = this.material.getItemTranslationKey();
        if (translationKey == null) {
            return Component.text((String)this.material.toString());
        }
        return Component.translatable((String)translationKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleIngredient that = (SimpleIngredient)o;
        return this.material == that.material;
    }

    public int hashCode() {
        return Objects.hashCode(this.material);
    }

    public String toString() {
        return "SimpleIngredient(" + this.getKey() + ")";
    }

    public static SimpleIngredient from(@NotNull ItemStack itemStack) {
        return new SimpleIngredient(itemStack.getType());
    }

    public static Optional<Ingredient> from(String materialStr) {
        return Optional.ofNullable(NamespacedKey.fromString((String)materialStr.toLowerCase(Locale.ROOT))).flatMap(namespacedKey -> Optional.ofNullable((Material)Registry.MATERIAL.get(namespacedKey))).map(SimpleIngredient::new);
    }
}

