/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.recipe;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.brew.BrewQuality;
import dev.jsinco.brewery.bukkit.recipe.BukkitRecipeResult;
import dev.jsinco.brewery.bukkit.recipe.RecipeEffect;
import dev.jsinco.brewery.bukkit.recipe.RecipeEffects;
import dev.jsinco.brewery.bukkit.util.ColorUtil;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.ConfigurationSection;
import dev.jsinco.brewery.moment.Interval;
import dev.jsinco.brewery.recipe.QualityData;
import dev.jsinco.brewery.recipe.RecipeResult;
import dev.jsinco.brewery.recipes.RecipeReader;
import dev.jsinco.brewery.recipes.RecipeResultReader;
import dev.jsinco.brewery.util.BreweryKey;
import java.util.List;
import java.util.Locale;
import org.bukkit.Color;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class BukkitRecipeResultReader
implements RecipeResultReader<ItemStack> {
    @Override
    public QualityData<RecipeResult<ItemStack>> readRecipeResults(ConfigurationSection configurationSection) {
        QualityData<RecipeEffects> recipeEffects = BukkitRecipeResultReader.getRecipeEffects(configurationSection);
        QualityData<Integer> customModelData = QualityData.readQualityFactoredString(configurationSection.getString("potion-attributes.custom-model-data")).map(Integer::parseInt);
        QualityData<String> itemModel = QualityData.readQualityFactoredString(configurationSection.getString("potion-attributes.item-model"));
        QualityData<List<String>> lore = QualityData.readQualityFactoredStringList(configurationSection.getStringList("potion-attributes.lore"));
        QualityData<Boolean> glint = QualityData.readQualityFactoredString(configurationSection.getString("potion-attributes.glint")).map(Boolean::parseBoolean);
        QualityData<String> names = QualityData.readQualityFactoredString(configurationSection.getString("potion-attributes.name"));
        QualityData<Color> colors = QualityData.readQualityFactoredString(configurationSection.getString("potion-attributes.color")).map(ColorUtil::parseColorString);
        QualityData<Boolean> appendBrewInfoLore = QualityData.readQualityFactoredString(configurationSection.getString("potion-attributes.append-brew-info-lore")).map(Boolean::parseBoolean);
        QualityData<String> customId = QualityData.readQualityFactoredString(configurationSection.getString("potion-attributes.custom-id"));
        return QualityData.fromValueMapper(brewQuality -> new BukkitRecipeResult.Builder().name((String)names.get((BrewQuality)((Object)brewQuality))).recipeEffects(recipeEffects.getOrDefault((BrewQuality)((Object)brewQuality), RecipeEffects.GENERIC)).lore(lore.getOrDefault((BrewQuality)((Object)brewQuality), List.of())).glint(glint.getOrDefault((BrewQuality)((Object)brewQuality), false)).color((Color)Preconditions.checkNotNull((Object)((Color)colors.get((BrewQuality)((Object)brewQuality))))).appendBrewInfoLore(appendBrewInfoLore.getOrDefault((BrewQuality)((Object)brewQuality), true)).customId((String)customId.get((BrewQuality)((Object)brewQuality))).customModelData(customModelData.getOrDefault((BrewQuality)((Object)brewQuality), -1)).itemModel((String)itemModel.get((BrewQuality)((Object)brewQuality))).build());
    }

    private static QualityData<RecipeEffects> getRecipeEffects(ConfigurationSection configurationSection) {
        QualityData<String> actionBar = QualityData.readQualityFactoredString(configurationSection.getString("messages.action-bar", null));
        QualityData<String> title = QualityData.readQualityFactoredString(configurationSection.getString("messages.title", null));
        QualityData<String> message = QualityData.readQualityFactoredString(configurationSection.getString("messages.message", null));
        QualityData<List> effects = QualityData.readQualityFactoredStringList(configurationSection.getStringList("effects")).map(list -> list.stream().map(BukkitRecipeResultReader::getEffect).toList());
        QualityData<List> events = QualityData.readQualityFactoredStringList(configurationSection.getStringList("events")).map(list -> list.stream().map(BreweryKey::parse).toList());
        QualityData<Integer> alcohol = QualityData.readQualityFactoredString(configurationSection.getString("alcohol", "0%")).map(RecipeReader::parseAlcoholString);
        return QualityData.fromValueMapper(quality -> new RecipeEffects.Builder().actionBar((String)actionBar.get((BrewQuality)((Object)quality))).title((String)title.get((BrewQuality)((Object)quality))).message((String)message.get((BrewQuality)((Object)quality))).alcohol(alcohol.getOrDefault((BrewQuality)((Object)quality), 0)).effects(effects.getOrDefault((BrewQuality)((Object)quality), List.of())).events(events.getOrDefault((BrewQuality)((Object)quality), List.of())).build());
    }

    private static RecipeEffect getEffect(String string) {
        Interval amplifierBounds;
        Interval durationBounds;
        if (!string.contains("/")) {
            PotionEffectType type = (PotionEffectType)Registry.EFFECT.get(NamespacedKey.fromString((String)string.toLowerCase(Locale.ROOT)));
            Preconditions.checkNotNull((Object)type);
            return new RecipeEffect(type, new Interval(1L, 1L), new Interval(1L, 1L));
        }
        String[] parts = string.split("/");
        PotionEffectType type = PotionEffectType.getByName((String)parts[0]);
        Preconditions.checkNotNull((Object)type, (Object)("invalid effect type: " + parts[0]));
        if (parts.length == 3) {
            durationBounds = Interval.parse(parts[2]);
            amplifierBounds = Interval.parse(parts[1]);
        } else {
            durationBounds = Interval.parse(parts[1]);
            amplifierBounds = new Interval(1L, 1L);
        }
        return new RecipeEffect(type, durationBounds, amplifierBounds);
    }
}

