/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration;

import dev.jsinco.brewery.configuration.BarrelSection;
import dev.jsinco.brewery.configuration.CauldronSection;
import dev.jsinco.brewery.configuration.DecayRateSection;
import dev.jsinco.brewery.configuration.EventSection;
import dev.jsinco.brewery.configuration.PukeSection;
import dev.jsinco.brewery.configuration.SoundSection;
import dev.jsinco.brewery.lib.eu.okaeri.configs.ConfigManager;
import dev.jsinco.brewery.lib.eu.okaeri.configs.OkaeriConfig;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.Comment;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.CustomKey;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.Exclude;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.OkaeriSerdesPack;
import dev.jsinco.brewery.lib.eu.okaeri.configs.yaml.snakeyaml.YamlSnakeYamlConfigurer;
import java.io.File;
import lombok.Generated;

public class Config
extends OkaeriConfig {
    @Comment(value={"Config version. Don't change this"})
    @CustomKey(value="config-version")
    private int configVersion = 1;
    @Comment(value={"What language file should we use? See: /TheBrewingProject/locale"})
    @CustomKey(value="language")
    private String language = "en-us";
    @Comment(value={"Allow hoppers to interact with distilleries and barrels"})
    @CustomKey(value="automation-enabled")
    private boolean automation = true;
    @Comment(value={"Whether an ingredient can be added into a brew regardless if it's not in any of the recipes"})
    @CustomKey(value="allow-unregistered-ingredients")
    private boolean allowUnregisteredIngredients = false;
    @Comment(value={"Whether items should be consumed when in creative mode when using it on tbp structures"})
    @CustomKey(value="consume-items-in-creative")
    private boolean consumeItemsInCreative = false;
    @CustomKey(value="cauldrons")
    private CauldronSection cauldrons = new CauldronSection();
    @CustomKey(value="barrels")
    private BarrelSection barrels = new BarrelSection();
    @CustomKey(value="puke")
    private PukeSection puke = new PukeSection();
    @CustomKey(value="events")
    private EventSection events = new EventSection();
    @CustomKey(value="decay-rates")
    private DecayRateSection decayRate = new DecayRateSection();
    @Comment(value={"This field accepts either a single sound definition or a list of definitions.", "If a list is provided, one sound will be chosen randomly.", "", "A single sound entry is a string with one of the following formats", "- <sound_id>", "- <sound_id>/<pitch>", "- <sound_id>/<min_pitch>;<max_pitch>", "", "See the default values below for examples"})
    @CustomKey(value="sounds")
    private SoundSection sounds = new SoundSection();
    @Exclude
    private static Config instance;

    public static void load(File dataFolder, OkaeriSerdesPack ... packs) {
        instance = ConfigManager.create(Config.class, it -> {
            it.withConfigurer(new YamlSnakeYamlConfigurer(), packs);
            it.withBindFile(new File(dataFolder, "config.yml"));
            it.withRemoveOrphans(true);
            it.saveDefaults();
            it.load(true);
        });
    }

    public static Config config() {
        return instance;
    }

    @Generated
    public int configVersion() {
        return this.configVersion;
    }

    @Generated
    public String language() {
        return this.language;
    }

    @Generated
    public boolean automation() {
        return this.automation;
    }

    @Generated
    public boolean allowUnregisteredIngredients() {
        return this.allowUnregisteredIngredients;
    }

    @Generated
    public boolean consumeItemsInCreative() {
        return this.consumeItemsInCreative;
    }

    @Generated
    public CauldronSection cauldrons() {
        return this.cauldrons;
    }

    @Generated
    public BarrelSection barrels() {
        return this.barrels;
    }

    @Generated
    public PukeSection puke() {
        return this.puke;
    }

    @Generated
    public EventSection events() {
        return this.events;
    }

    @Generated
    public DecayRateSection decayRate() {
        return this.decayRate;
    }

    @Generated
    public SoundSection sounds() {
        return this.sounds;
    }
}

