/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration;

import dev.jsinco.brewery.event.CustomEvent;
import dev.jsinco.brewery.event.CustomEventRegistry;
import dev.jsinco.brewery.event.EventStep;
import dev.jsinco.brewery.event.NamedDrunkEvent;
import dev.jsinco.brewery.event.step.ApplyPotionEffect;
import dev.jsinco.brewery.event.step.ConditionalWaitStep;
import dev.jsinco.brewery.event.step.ConsumeStep;
import dev.jsinco.brewery.lib.eu.okaeri.configs.OkaeriConfig;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.Comment;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.CustomKey;
import dev.jsinco.brewery.moment.Interval;
import dev.jsinco.brewery.util.BreweryKey;
import dev.jsinco.brewery.vector.BreweryLocation;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import lombok.Generated;

public class EventSection
extends OkaeriConfig {
    @CustomKey(value="kick-event")
    private KickEventSection kickEvent = new KickEventSection();
    @Comment(value={"How many game minutes will a player be passed out?"})
    @CustomKey(value="pass-out-time")
    private int passOutTime = 5;
    @Comment(value={"Drunken messages to send if the drunk_message event is enabled (not recommended to have enabled, gets a bit spammy)"})
    @CustomKey(value="messages")
    private List<String> drunkMessages = List.of("I love you <random_player_name>, you're my best friend.", "I could do one more.", "Who is she?", "Watch this!", "I'm not drunk. You're drunk.");
    @Comment(value={"Make your own events, see the wiki at https://hangar.papermc.io/BreweryTeam/TheBrewingProject/pages/Wiki/Configuration#-events"})
    @CustomKey(value="custom-events")
    private CustomEventRegistry customEvents = CustomEventRegistry.builder().addEvent(new CustomEvent.Builder().alcoholRequirement(60).toxinsRequirement(90).probabilityWeight(5).addStep(new EventStep.Builder().addProperty(NamedDrunkEvent.fromKey("pass_out")).build()).addStep(new EventStep.Builder().addProperty(new ConditionalWaitStep(ConditionalWaitStep.Condition.JOIN)).addProperty(NamedDrunkEvent.fromKey("teleport")).addProperty(new ConsumeStep(-30, -15)).build()).build(BreweryKey.parse("memory_loss"))).addEvent(new CustomEvent.Builder().addStep(new EventStep.Builder().addProperty(new ApplyPotionEffect("darkness", new Interval(1L, 1L), new Interval(400L, 400L))).build()).build(BreweryKey.parse("tunnel_vision"))).build();
    @Comment(value={"What events will be randomly chosen over time when the player is drunk"})
    @CustomKey(value="enabled-random-events")
    private List<String> enabledRandomEvents = List.of("puke", "memory_loss", "stumble", "chicken", "nausea", "tunnel_vision", "drunken_walk", "hallucination", "fever", "kaboom");
    @Comment(value={"Teleport destinations for the 'teleport' event"})
    @CustomKey(value="teleport-destinations")
    private List<BreweryLocation.Uncompiled> teleportDestinations = Stream.of(worldUuids -> worldUuids.isEmpty() ? null : new BreweryLocation(0, 80, 0, (UUID)worldUuids.getFirst())).toList();
    @Comment(value={"Deny joining the server if too drunk"})
    @CustomKey(value="drunken-join-deny")
    private boolean drunkenJoinDeny = true;
    @Comment(value={"Transform text with blurred speech if the player is drunk enough"})
    @CustomKey(value="blurred-speech")
    private boolean blurredSpeech = true;

    @Generated
    public KickEventSection kickEvent() {
        return this.kickEvent;
    }

    @Generated
    public int passOutTime() {
        return this.passOutTime;
    }

    @Generated
    public List<String> drunkMessages() {
        return this.drunkMessages;
    }

    @Generated
    public CustomEventRegistry customEvents() {
        return this.customEvents;
    }

    @Generated
    public List<String> enabledRandomEvents() {
        return this.enabledRandomEvents;
    }

    @Generated
    public List<BreweryLocation.Uncompiled> teleportDestinations() {
        return this.teleportDestinations;
    }

    @Generated
    public boolean drunkenJoinDeny() {
        return this.drunkenJoinDeny;
    }

    @Generated
    public boolean blurredSpeech() {
        return this.blurredSpeech;
    }

    public static class KickEventSection
    extends OkaeriConfig {
        private String kickEventMessage = null;
        private String kickServerMessage = null;

        @Generated
        public String kickEventMessage() {
            return this.kickEventMessage;
        }

        @Generated
        public String kickServerMessage() {
            return this.kickServerMessage;
        }
    }
}

