/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration.serializers;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.event.CustomEvent;
import dev.jsinco.brewery.event.EventStep;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;

public class CustomEventSerializer
implements ObjectSerializer<CustomEvent> {
    @Override
    public boolean supports(@NonNull Class<? super CustomEvent> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return CustomEvent.class == type;
    }

    @Override
    public void serialize(@NonNull CustomEvent object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        if (object.alcoholRequirement() != 0) {
            eventData.put("alcohol", object.alcoholRequirement());
        }
        if (object.toxinsRequirement() != 0) {
            eventData.put("toxins", object.toxinsRequirement());
        }
        if (object.probabilityWeight() != 0) {
            eventData.put("probability-weight", object.probabilityWeight());
        }
        eventData.put("steps", object.getSteps());
        data.setValue(eventData);
    }

    @Override
    public CustomEvent deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        Integer alcohol = data.get("alcohol", Integer.class);
        Integer toxin = data.get("toxins", Integer.class);
        Integer probabilityWeight = data.get("probability-weight", Integer.class);
        CustomEvent.Builder builder = new CustomEvent.Builder().alcoholRequirement(alcohol == null ? 0 : alcohol).toxinsRequirement(toxin == null ? 0 : toxin).probabilityWeight(probabilityWeight == null ? 0 : probabilityWeight);
        List<EventStep> steps = data.getAsList("steps", EventStep.class);
        Preconditions.checkArgument((steps != null ? 1 : 0) != 0, (Object)"Steps has to be a list");
        steps.forEach(builder::addStep);
        return builder.build();
    }
}

