/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.event;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import dev.jsinco.brewery.event.DrunkEvent;
import dev.jsinco.brewery.event.EventStepProperty;
import dev.jsinco.brewery.util.BreweryKey;
import dev.jsinco.brewery.util.BreweryKeyed;
import dev.jsinco.brewery.util.Registry;
import java.util.Locale;

public class NamedDrunkEvent
implements DrunkEvent,
BreweryKeyed,
EventStepProperty {
    private final String name;
    @SerializedName(value="alcohol_requirement")
    private final int alcoholRequirement;
    @SerializedName(value="toxins_requirement")
    private final int toxinsRequirement;
    @SerializedName(value="probability_weight")
    private final int probabilityWeight;
    @Expose(serialize=false, deserialize=false)
    private BreweryKey key;

    public NamedDrunkEvent(String name, int alcoholRequirement, int toxinsRequirement, int probabilityWeight) {
        this.name = name;
        this.alcoholRequirement = alcoholRequirement;
        this.toxinsRequirement = toxinsRequirement;
        this.probabilityWeight = probabilityWeight;
        this.key = BreweryKey.parse(name.toLowerCase(Locale.ROOT));
    }

    @Override
    public int alcoholRequirement() {
        return this.alcoholRequirement;
    }

    @Override
    public int toxinsRequirement() {
        return this.toxinsRequirement;
    }

    @Override
    public BreweryKey key() {
        if (this.key == null) {
            this.key = BreweryKey.parse(this.name.toLowerCase(Locale.ROOT));
        }
        return this.key;
    }

    @Override
    public String displayName() {
        return this.name.toLowerCase(Locale.ROOT);
    }

    @Override
    public int probabilityWeight() {
        return this.probabilityWeight;
    }

    public static NamedDrunkEvent fromKey(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
        return Registry.DRUNK_EVENT.get(BreweryKey.parse(key));
    }
}

