/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.ingredient;

import dev.jsinco.brewery.ingredient.Ingredient;
import dev.jsinco.brewery.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public interface IngredientManager<I> {
    public Ingredient getIngredient(@NotNull I var1);

    public CompletableFuture<Optional<Ingredient>> getIngredient(@NotNull String var1);

    public CompletableFuture<Pair<Ingredient, Integer>> getIngredientWithAmount(String var1) throws IllegalArgumentException;

    public CompletableFuture<Map<Ingredient, Integer>> getIngredientsWithAmount(List<String> var1) throws IllegalArgumentException;

    public static void merge(Map<Ingredient, Integer> mutableIngredientsMap, Map<Ingredient, Integer> ingredients) {
        for (Map.Entry<Ingredient, Integer> ingredient : ingredients.entrySet()) {
            IngredientManager.insertIngredientIntoMap(mutableIngredientsMap, new Pair<Ingredient, Integer>(ingredient.getKey(), ingredient.getValue()));
        }
    }

    public static void insertIngredientIntoMap(Map<Ingredient, Integer> mutableIngredientsMap, Pair<Ingredient, Integer> ingredient) {
        int amount = mutableIngredientsMap.computeIfAbsent(ingredient.first(), ignored -> 0);
        mutableIngredientsMap.put(ingredient.first(), amount + ingredient.second());
    }
}

