/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.recipes;

import dev.jsinco.brewery.brew.Brew;
import dev.jsinco.brewery.brew.BrewQuality;
import dev.jsinco.brewery.brew.BrewScore;
import dev.jsinco.brewery.brew.BrewingStep;
import dev.jsinco.brewery.brew.PartialBrewScore;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class BrewScoreImpl
implements BrewScore {
    public static final BrewScoreImpl EXCELLENT = new BrewScoreImpl(1.0);
    private static final char FULL_STAR = '\u2605';
    private static final char HALF_STAR = '\u2bea';
    private static final char EMPTY_STAR = '\u2606';
    private final List<List<PartialBrewScore>> scores;
    private final boolean completed;
    private final double brewDifficulty;

    public BrewScoreImpl(double score) {
        this.scores = List.of(List.of(new PartialBrewScore(score, PartialBrewScore.Type.TIME)));
        this.completed = true;
        this.brewDifficulty = 1.0;
    }

    public static BrewScoreImpl failed(Brew brew) {
        List<List<PartialBrewScore>> scores = brew.getCompletedSteps().stream().map(BrewingStep::failedScores).toList();
        return new BrewScoreImpl(scores, true, 1.0);
    }

    @Override
    @Nullable
    public BrewQuality brewQuality() {
        return BrewScoreImpl.quality(this.score());
    }

    public BrewScoreImpl(List<List<PartialBrewScore>> scores, boolean completed, double brewDifficulty) {
        this.scores = scores;
        this.completed = completed;
        this.brewDifficulty = brewDifficulty / 2.0;
    }

    @Override
    public List<PartialBrewScore> getPartialScores(int stepIndex) {
        return this.scores.get(stepIndex);
    }

    @Override
    public double score() {
        return BrewScoreImpl.applyDifficulty(this.rawScore(), this.brewDifficulty);
    }

    public static double applyDifficulty(double score, double brewDifficulty) {
        score = Math.min(score + 0.05, 1.0);
        if (brewDifficulty <= 0.0) {
            return 1.0;
        }
        double scoreWithDifficulty = brewDifficulty == 1.0 ? score : (Math.pow(brewDifficulty, 3.0 * score) - 1.0) / (Math.pow(brewDifficulty, 3.0) - 1.0);
        return Math.max(scoreWithDifficulty - 0.3, 0.0) * 1.0 / 0.7;
    }

    @Override
    public String displayName() {
        StringBuilder builder = new StringBuilder();
        int score = (int)(this.score() * 10.0);
        int fullStars = score / 2;
        int remainder = score % 2;
        builder.repeat(9733, fullStars);
        if (remainder == 1) {
            builder.append('\u2bea');
            builder.repeat(9734, 4 - fullStars);
        } else {
            builder.repeat(9734, 5 - fullStars);
        }
        return builder.toString();
    }

    @Override
    public double rawScore() {
        return this.scores.stream().map(this::rawPartialScore).reduce(1.0, (aDouble, aDouble2) -> aDouble * aDouble2);
    }

    private double rawPartialScore(List<PartialBrewScore> partialBrewScores) {
        return partialBrewScores.stream().map(PartialBrewScore::score).map(score -> partialBrewScores.size() == 1 ? score : Math.sqrt(score)).reduce(1.0, (value1, value2) -> value1 * value2);
    }

    @Override
    public boolean completed() {
        return this.completed;
    }

    @Override
    public double brewDifficulty() {
        return this.brewDifficulty;
    }

    public static BrewQuality quality(double score) {
        if (score >= 0.8) {
            return BrewQuality.EXCELLENT;
        }
        if (score >= 0.6) {
            return BrewQuality.GOOD;
        }
        if (score > 0.0) {
            return BrewQuality.BAD;
        }
        return null;
    }
}

