/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dev.jsinco.brewery.breweries.BarrelType;
import dev.jsinco.brewery.breweries.CauldronType;
import dev.jsinco.brewery.event.NamedDrunkEvent;
import dev.jsinco.brewery.structure.StructureMeta;
import dev.jsinco.brewery.structure.StructureType;
import dev.jsinco.brewery.util.BreweryKey;
import dev.jsinco.brewery.util.BreweryKeyed;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Registry<T extends BreweryKeyed> {
    public static final Registry<BarrelType> BARREL_TYPE = Registry.fromEnums(BarrelType.class);
    public static final Registry<CauldronType> CAULDRON_TYPE = Registry.fromEnums(CauldronType.class);
    public static final Registry<StructureMeta<?>> STRUCTURE_META = Registry.fromFields(StructureMeta.class);
    public static final Registry<StructureType> STRUCTURE_TYPE = Registry.fromFields(StructureType.class);
    public static final Registry<NamedDrunkEvent> DRUNK_EVENT = Registry.fromJson("/named_drunk_events.json", NamedDrunkEvent.class);
    private final ImmutableMap<BreweryKey, T> backing;

    private Registry(Collection<T> values) {
        ImmutableMap.Builder registryBacking = ImmutableMap.builder();
        values.forEach(value -> registryBacking.put((Object)value.key(), value));
        this.backing = registryBacking.build();
    }

    public Collection<T> values() {
        return this.backing.values();
    }

    @Nullable
    public T get(BreweryKey key) {
        return (T)((BreweryKeyed)this.backing.get((Object)key));
    }

    public boolean containsKey(BreweryKey key) {
        return this.backing.containsKey((Object)key);
    }

    private static <E extends Enum<E>> Registry<E> fromEnums(Class<E> enumClass) {
        return new Registry<Enum>(Arrays.stream((Enum[])enumClass.getEnumConstants()).toList());
    }

    private static <T extends BreweryKeyed> Registry<? extends T> fromFields(Class<T> tClass) {
        try {
            ArrayList<BreweryKeyed> tList = new ArrayList<BreweryKeyed>();
            for (Field field : tClass.getDeclaredFields()) {
                Object staticField;
                if (!Modifier.isStatic(field.getModifiers()) || !tClass.isInstance(staticField = field.get(null))) continue;
                tList.add((BreweryKeyed)tClass.cast(staticField));
            }
            return new Registry(tList);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T extends BreweryKeyed> Registry<T> fromJson(String path, Class<T> tClass) {
        Gson gson = new Gson();
        try (InputStream inputStream = Registry.class.getResourceAsStream(path);){
            Registry<T> registry;
            try (InputStreamReader reader = new InputStreamReader((InputStream)Preconditions.checkNotNull((Object)inputStream, (Object)("InputStream for path '" + path + "' cannot be null")));){
                Type listType = TypeToken.getParameterized(List.class, (Type[])new Type[]{tClass}).getType();
                List tList = (List)gson.fromJson((Reader)reader, listType);
                registry = new Registry<T>(tList);
            }
            return registry;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read from JSON at path: " + path, e);
        }
    }
}

