/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import dev.jsinco.brewery.brew.Brew;
import dev.jsinco.brewery.brew.BrewQuality;
import dev.jsinco.brewery.brew.BrewScore;
import dev.jsinco.brewery.brew.BrewSerializer;
import dev.jsinco.brewery.brew.BrewingStep;
import dev.jsinco.brewery.brew.PartialBrewScore;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.recipe.Recipe;
import dev.jsinco.brewery.recipe.RecipeRegistry;
import dev.jsinco.brewery.recipes.BrewScoreImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class BrewImpl
implements Brew {
    private final List<BrewingStep> steps;
    public static final BrewSerializer SERIALIZER = new BrewSerializer();

    public BrewImpl(BrewingStep.Cook cook) {
        this(List.of(cook));
    }

    public BrewImpl(BrewingStep.Mix mix) {
        this(List.of(mix));
    }

    public BrewImpl(@NotNull List<BrewingStep> steps) {
        this.steps = steps;
    }

    @Override
    public BrewImpl withStep(BrewingStep step) {
        return new BrewImpl(Stream.concat(this.steps.stream(), Stream.of(step)).toList());
    }

    @Override
    public BrewImpl witModifiedLastStep(Function<BrewingStep, BrewingStep> modifier) {
        BrewingStep newStep = modifier.apply(this.steps.getLast());
        return new BrewImpl(Stream.concat(this.steps.subList(0, this.steps.size() - 1).stream(), Stream.of(newStep)).toList());
    }

    @Override
    public <B extends BrewingStep> BrewImpl withLastStep(Class<B> bClass, Function<B, B> modifier, Supplier<B> stepSupplier) {
        if (!this.steps.isEmpty() && bClass.isInstance(this.lastStep())) {
            BrewingStep newStep = (BrewingStep)modifier.apply((BrewingStep)bClass.cast(this.lastStep()));
            return new BrewImpl(Stream.concat(this.steps.subList(0, this.steps.size() - 1).stream(), Stream.of(newStep)).toList());
        }
        return this.withStep((BrewingStep)stepSupplier.get());
    }

    @Override
    public List<BrewingStep> getCompletedSteps() {
        return this.steps.stream().filter(this::isCompleted).toList();
    }

    private boolean isCompleted(BrewingStep step) {
        BrewingStep.Age age;
        return !(step instanceof BrewingStep.Age) || (age = (BrewingStep.Age)step).time().moment() > Config.config().barrels().agingYearTicks() / 2L;
    }

    @Override
    public <I> Optional<Recipe<I>> closestRecipe(RecipeRegistry<I> registry) {
        double bestScore = 0.0;
        Recipe<I> bestMatch = null;
        for (Recipe<I> recipe : registry.getRecipes()) {
            double score = this.score(recipe).rawScore();
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestMatch = recipe;
        }
        return Optional.ofNullable(bestMatch);
    }

    @Override
    @NotNull
    public BrewScore score(Recipe<?> recipe) {
        List<BrewingStep> recipeSteps = recipe.getSteps();
        ArrayList<List<PartialBrewScore>> scores = new ArrayList<List<PartialBrewScore>>();
        List<BrewingStep> completedSteps = this.getCompletedSteps();
        if (completedSteps.size() > recipeSteps.size()) {
            return BrewScoreImpl.failed(this);
        }
        for (int i = 0; i < completedSteps.size(); ++i) {
            BrewingStep recipeStep = recipeSteps.get(i);
            scores.add(recipeStep.proximityScores(completedSteps.get(i)));
        }
        boolean completed = completedSteps.size() == recipeSteps.size();
        BrewScoreImpl brewScore = new BrewScoreImpl(scores, completed, recipe.getBrewDifficulty());
        if (brewScore.brewQuality() == null) {
            scores.removeLast();
            scores.add(recipeSteps.get(completedSteps.size() - 1).maximumScores(completedSteps.getLast()));
            BrewScoreImpl uncompleted = new BrewScoreImpl(scores, false, recipe.getBrewDifficulty());
            if (uncompleted.brewQuality() != null) {
                return uncompleted;
            }
        }
        return brewScore;
    }

    @Override
    public Optional<BrewQuality> quality(Recipe<?> recipe) {
        return Optional.ofNullable(this.score(recipe).brewQuality());
    }

    @Override
    @NotNull
    public BrewingStep lastCompletedStep() {
        for (int i = this.steps.size() - 1; i >= 0; --i) {
            BrewingStep step = this.steps.get(i);
            if (!this.isCompleted(step)) continue;
            return step;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    @NotNull
    public BrewingStep lastStep() {
        return this.steps.getLast();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BrewImpl brew = (BrewImpl)other;
        return this.steps.equals(brew.steps);
    }

    @Override
    @Generated
    public List<BrewingStep> getSteps() {
        return this.steps;
    }
}

