/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.jsinco.brewery.brew.Brew;
import dev.jsinco.brewery.brew.BrewImpl;
import dev.jsinco.brewery.brew.BrewingStep;
import dev.jsinco.brewery.brew.BrewingStepSerializer;
import dev.jsinco.brewery.ingredient.IngredientManager;
import dev.jsinco.brewery.util.FutureUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class BrewSerializer {
    public static final BrewSerializer INSTANCE = new BrewSerializer();

    public JsonArray serialize(Brew brew) {
        JsonArray array = new JsonArray();
        for (BrewingStep step : brew.getSteps()) {
            array.add((JsonElement)BrewingStepSerializer.INSTANCE.serialize(step));
        }
        return array;
    }

    public CompletableFuture<Brew> deserialize(JsonArray jsonArray, IngredientManager<?> ingredientManager) {
        List brewingStepFutures = jsonArray.asList().stream().map(jsonElement -> BrewingStepSerializer.INSTANCE.deserialize((JsonElement)jsonElement, ingredientManager)).toList();
        return FutureUtil.mergeFutures(brewingStepFutures).thenApplyAsync(BrewImpl::new);
    }
}

