/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import dev.jsinco.brewery.brew.PartialBrewScore;
import dev.jsinco.brewery.breweries.BarrelType;
import dev.jsinco.brewery.breweries.CauldronType;
import dev.jsinco.brewery.ingredient.Ingredient;
import dev.jsinco.brewery.moment.Moment;
import java.util.List;
import java.util.Map;

public interface BrewingStep {
    public List<PartialBrewScore> proximityScores(BrewingStep var1);

    public StepType stepType();

    public List<PartialBrewScore> maximumScores(BrewingStep var1);

    public List<PartialBrewScore> failedScores();

    public static enum StepType {
        COOK,
        DISTILL,
        AGE,
        MIX;

    }

    public static interface Mix
    extends BrewingStep,
    TimedStep,
    IngredientsStep {
        public Mix withIngredients(Map<Ingredient, Integer> var1);

        public Mix withTime(Moment var1);
    }

    public static interface Age
    extends BrewingStep,
    TimedStep {
        public BarrelType barrelType();

        public Age withAge(Moment var1);
    }

    public static interface Distill
    extends BrewingStep {
        public int runs();

        public Distill incrementAmount();
    }

    public static interface Cook
    extends BrewingStep,
    TimedStep,
    IngredientsStep {
        public CauldronType cauldronType();

        public Cook withBrewTime(Moment var1);

        public Cook withIngredients(Map<Ingredient, Integer> var1);
    }

    public static interface IngredientsStep {
        public Map<? extends Ingredient, Integer> ingredients();
    }

    public static interface TimedStep {
        public Moment time();
    }
}

