/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import dev.jsinco.brewery.brew.BrewingStep;
import dev.jsinco.brewery.brew.BrewingStepUtil;
import dev.jsinco.brewery.brew.PartialBrewScore;
import dev.jsinco.brewery.breweries.CauldronType;
import dev.jsinco.brewery.ingredient.Ingredient;
import dev.jsinco.brewery.moment.Moment;
import java.util.List;
import java.util.Map;

public record CookStepImpl(Moment time, Map<? extends Ingredient, Integer> ingredients, CauldronType cauldronType) implements BrewingStep.Cook
{
    private static final List<PartialBrewScore> BREW_STEP_MISMATCH = List.of(new PartialBrewScore(0.0, PartialBrewScore.Type.TIME), new PartialBrewScore(0.0, PartialBrewScore.Type.INGREDIENTS));

    @Override
    public CookStepImpl withBrewTime(Moment brewTime) {
        return new CookStepImpl(brewTime, this.ingredients, this.cauldronType);
    }

    @Override
    public CookStepImpl withIngredients(Map<Ingredient, Integer> ingredients) {
        return new CookStepImpl(this.time, ingredients, this.cauldronType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<PartialBrewScore> proximityScores(BrewingStep other) {
        Moment otherTime;
        Object object;
        if (!(other instanceof CookStepImpl)) return BREW_STEP_MISMATCH;
        CookStepImpl cookStepImpl = (CookStepImpl)other;
        try {
            object = cookStepImpl.time();
            otherTime = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object otherIngredients = object = cookStepImpl.ingredients();
        Object otherType = object = cookStepImpl.cauldronType();
        double cauldronTypeScore = this.cauldronType.equals(otherType) ? 1.0 : 0.0;
        double timeScore = Math.sqrt(BrewingStepUtil.nearbyValueScore(this.time.moment(), otherTime.moment()));
        double ingredientsScore = BrewingStepUtil.getIngredientsScore(this.ingredients, (Map<Ingredient, Integer>)otherIngredients);
        return List.of(new PartialBrewScore(cauldronTypeScore * timeScore, PartialBrewScore.Type.TIME), new PartialBrewScore(ingredientsScore, PartialBrewScore.Type.INGREDIENTS));
    }

    @Override
    public BrewingStep.StepType stepType() {
        return BrewingStep.StepType.COOK;
    }

    @Override
    public List<PartialBrewScore> maximumScores(BrewingStep other) {
        if (!(other instanceof BrewingStep.Cook)) {
            return BREW_STEP_MISMATCH;
        }
        BrewingStep.Cook cook = (BrewingStep.Cook)other;
        double cauldronTypeScore = this.cauldronType().equals(cook.cauldronType()) ? 1.0 : 0.0;
        double maximumCookTimeScore = this.time.moment() > cook.time().moment() ? 1.0 : BrewingStepUtil.nearbyValueScore(this.time.moment(), cook.time().moment());
        double ingredientsScore = BrewingStepUtil.getIngredientsScore(this.ingredients(), cook.ingredients());
        return List.of(new PartialBrewScore(cauldronTypeScore * maximumCookTimeScore, PartialBrewScore.Type.TIME), new PartialBrewScore(ingredientsScore, PartialBrewScore.Type.INGREDIENTS));
    }

    @Override
    public List<PartialBrewScore> failedScores() {
        return BREW_STEP_MISMATCH;
    }
}

