/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.brew;

import dev.jsinco.brewery.brew.AgeStepImpl;
import dev.jsinco.brewery.brew.BrewingStep;
import dev.jsinco.brewery.brew.CookStepImpl;
import dev.jsinco.brewery.brew.DistillStepImpl;
import dev.jsinco.brewery.brew.MixStepImpl;
import dev.jsinco.brewery.bukkit.ingredient.BukkitIngredientManager;
import dev.jsinco.brewery.ingredient.Ingredient;
import dev.jsinco.brewery.ingredient.IngredientManager;
import dev.jsinco.brewery.moment.Interval;
import dev.jsinco.brewery.moment.Moment;
import dev.jsinco.brewery.moment.PassedMoment;
import dev.jsinco.brewery.util.BreweryKey;
import dev.jsinco.brewery.util.DecoderEncoder;
import dev.jsinco.brewery.util.Pair;
import dev.jsinco.brewery.util.Registry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class BrewingStepPdcType
implements PersistentDataType<byte[], BrewingStep> {
    @NotNull
    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    @NotNull
    public Class<BrewingStep> getComplexType() {
        return BrewingStep.class;
    }

    public byte @NotNull [] toPrimitive(@NotNull BrewingStep complex, @NotNull PersistentDataAdapterContext context) {
        Object object;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(output);
        try {
            dataOutputStream.writeUTF(complex.stepType().name());
            BrewingStep brewingStep = complex;
            Objects.requireNonNull(brewingStep);
            object = brewingStep;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BrewingStep.Age.class, BrewingStep.Cook.class, BrewingStep.Distill.class, BrewingStep.Mix.class}, (Object)object, n)) {
                case 0: {
                    BrewingStep.Age age = (BrewingStep.Age)object;
                    this.encodeMoment(age.time(), dataOutputStream);
                    dataOutputStream.writeUTF(age.barrelType().key().toString());
                    break;
                }
                case 1: {
                    BrewingStep.Cook cook = (BrewingStep.Cook)object;
                    this.encodeMoment(cook.time(), dataOutputStream);
                    this.encodeIngredients(cook.ingredients(), dataOutputStream);
                    dataOutputStream.writeUTF(cook.cauldronType().key().toString());
                    break;
                }
                case 2: {
                    BrewingStep.Distill distill = (BrewingStep.Distill)object;
                    dataOutputStream.writeInt(distill.runs());
                    break;
                }
                case 3: {
                    BrewingStep.Mix mix = (BrewingStep.Mix)object;
                    this.encodeMoment(mix.time(), dataOutputStream);
                    this.encodeIngredients(mix.ingredients(), dataOutputStream);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(complex));
                }
            }
            object = output.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        dataOutputStream.close();
        return object;
    }

    @NotNull
    public BrewingStep fromPrimitive(byte @NotNull [] primitive, @NotNull PersistentDataAdapterContext context) {
        Record record;
        ByteArrayInputStream input = new ByteArrayInputStream(primitive);
        DataInputStream dataInputStream = new DataInputStream(input);
        try {
            BrewingStep.StepType stepType = BrewingStep.StepType.valueOf(dataInputStream.readUTF());
            record = switch (stepType) {
                default -> throw new MatchException(null, null);
                case BrewingStep.StepType.COOK -> new CookStepImpl(this.decodeMoment(dataInputStream), this.decodeIngredients(dataInputStream), Registry.CAULDRON_TYPE.get(BreweryKey.parse(dataInputStream.readUTF())));
                case BrewingStep.StepType.DISTILL -> new DistillStepImpl(dataInputStream.readInt());
                case BrewingStep.StepType.AGE -> new AgeStepImpl(this.decodeMoment(dataInputStream), Registry.BARREL_TYPE.get(BreweryKey.parse(dataInputStream.readUTF())));
                case BrewingStep.StepType.MIX -> new MixStepImpl(this.decodeMoment(dataInputStream), this.decodeIngredients(dataInputStream));
            };
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        dataInputStream.close();
        return record;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void encodeMoment(Moment moment, DataOutputStream dataOutputStream) throws IOException {
        long stop;
        long start;
        if (!(moment instanceof Interval)) {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeLong(moment.moment());
            return;
        }
        Interval interval = (Interval)moment;
        try {
            long l;
            start = l = interval.start();
            stop = l = interval.stop();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeLong(start);
        dataOutputStream.writeLong(stop);
    }

    private Moment decodeMoment(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream.readBoolean()) {
            return new PassedMoment(dataInputStream.readLong());
        }
        return new Interval(dataInputStream.readLong(), dataInputStream.readLong());
    }

    public void encodeIngredients(@NotNull Map<? extends Ingredient, Integer> ingredients, OutputStream outputStream) {
        byte[][] bytesArray = (byte[][])ingredients.entrySet().stream().map(entry -> ((Ingredient)entry.getKey()).getKey() + "/" + String.valueOf(entry.getValue())).map(string -> string.getBytes(StandardCharsets.UTF_8)).toArray(x$0 -> new byte[x$0][]);
        try {
            DecoderEncoder.encode(bytesArray, outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public Map<? extends Ingredient, Integer> decodeIngredients(InputStream inputStream) {
        byte[][] bytesArray;
        HashMap ingredients = new HashMap();
        try {
            bytesArray = DecoderEncoder.decode(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Arrays.stream(bytesArray).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).map(BukkitIngredientManager.INSTANCE::getIngredientWithAmount).forEach(ingredientAmountPair -> IngredientManager.insertIngredientIntoMap(ingredients, (Pair)ingredientAmountPair.join()));
        return ingredients;
    }
}

