/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.command.BreweryCommand;
import dev.jsinco.brewery.configuration.locale.TranslationsConfig;
import dev.jsinco.brewery.effect.DrunkState;
import dev.jsinco.brewery.effect.DrunksManager;
import dev.jsinco.brewery.effect.DrunksManagerImpl;
import dev.jsinco.brewery.event.DrunkEvent;
import dev.jsinco.brewery.util.MessageUtil;
import dev.jsinco.brewery.util.Pair;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class StatusCommand {
    private static int set(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        OfflinePlayer target = BreweryCommand.getOfflinePlayer(context);
        ((DrunksManagerImpl)TheBrewingProject.getInstance().getDrunksManager()).clear(target.getUniqueId());
        return StatusCommand.consume(context);
    }

    private static int clear(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        OfflinePlayer target = BreweryCommand.getOfflinePlayer(context);
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        ((DrunksManagerImpl)TheBrewingProject.getInstance().getDrunksManager()).clear(target.getUniqueId());
        MessageUtil.message((Audience)sender, TranslationsConfig.COMMAND_STATUS_CLEAR_MESSAGE, new TagResolver[]{Placeholder.unparsed((String)"player_name", (String)target.getName())});
        return 1;
    }

    private static int consume(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        OfflinePlayer target = BreweryCommand.getOfflinePlayer(context);
        int alcohol = (Integer)context.getArgument("alcohol", Integer.TYPE);
        int toxins = (Integer)context.getArgument("toxins", Integer.TYPE);
        DrunksManager drunksManager = TheBrewingProject.getInstance().getDrunksManager();
        drunksManager.consume(target.getUniqueId(), alcohol, toxins);
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        sender.sendMessage(StatusCommand.compileStatusMessage(target, drunksManager, TranslationsConfig.COMMAND_STATUS_SET_MESSAGE));
        return 1;
    }

    private static int info(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        OfflinePlayer target = BreweryCommand.getOfflinePlayer(context);
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        DrunksManager drunksManager = TheBrewingProject.getInstance().getDrunksManager();
        sender.sendMessage(StatusCommand.compileStatusMessage(target, drunksManager, TranslationsConfig.COMMAND_STATUS_INFO_MESSAGE));
        return 1;
    }

    private static Component compileStatusMessage(OfflinePlayer target, DrunksManager drunksManager, String message) {
        DrunkState drunkState = drunksManager.getDrunkState(target.getUniqueId());
        Pair<DrunkEvent, Long> nextEvent = drunksManager.getPlannedEvent(target.getUniqueId());
        drunksManager.getPlannedEvent(target.getUniqueId());
        String targetName = target.getName();
        return MessageUtil.miniMessage(message, new TagResolver[]{Formatter.number((String)"alcohol", (Number)(drunkState == null ? 0 : drunkState.alcohol())), Formatter.number((String)"toxins", (Number)(drunkState == null ? 0 : drunkState.toxins())), Placeholder.unparsed((String)"player_name", (String)(targetName == null ? "null" : targetName)), Formatter.number((String)"next_event_time", (Number)(nextEvent == null ? 0L : nextEvent.second() - TheBrewingProject.getInstance().getTime())), Placeholder.unparsed((String)"next_event", (String)(nextEvent == null ? TranslationsConfig.NO_EVENT_PLANNED : nextEvent.first().displayName()))});
    }

    public static ArgumentBuilder<CommandSourceStack, ?> command() {
        LiteralArgumentBuilder root = Commands.literal((String)"status");
        List<ArgumentBuilder> subArguments = List.of(Commands.literal((String)"info").executes(StatusCommand::info), Commands.literal((String)"clear").executes(StatusCommand::clear), Commands.literal((String)"consume").then(Commands.argument((String)"alcohol", (ArgumentType)IntegerArgumentType.integer((int)-100, (int)100)).then(Commands.argument((String)"toxins", (ArgumentType)IntegerArgumentType.integer((int)-100, (int)100)).executes(StatusCommand::consume))), Commands.literal((String)"set").then(Commands.argument((String)"alcohol", (ArgumentType)IntegerArgumentType.integer((int)-100, (int)100)).then(Commands.argument((String)"toxins", (ArgumentType)IntegerArgumentType.integer((int)-100, (int)100)).executes(StatusCommand::set))));
        subArguments.forEach(arg_0 -> ((ArgumentBuilder)root).then(arg_0));
        root.then(BreweryCommand.offlinePlayerBranch(argument -> subArguments.forEach(arg_0 -> ((ArgumentBuilder)argument).then(arg_0))));
        return root;
    }
}

