/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.integration;

import dev.jsinco.brewery.bukkit.ingredient.PluginIngredient;
import dev.jsinco.brewery.bukkit.integration.Integration;
import dev.jsinco.brewery.ingredient.Ingredient;
import dev.jsinco.brewery.util.BreweryKey;
import dev.jsinco.brewery.util.Logger;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ItemIntegration
extends Integration {
    public Optional<ItemStack> createItem(String var1);

    default public CompletableFuture<Optional<Ingredient>> createIngredient(String id) {
        return this.initialized().handleAsync((ignored1, exception) -> {
            if (exception != null) {
                Logger.logErr("Couldn't create PluginIngredient for id '" + this.getId() + "'.");
                Logger.logErr(exception);
                return Optional.empty();
            }
            return Optional.of(new PluginIngredient(new BreweryKey(this.getId(), id), this));
        });
    }

    @Nullable
    public Component displayName(String var1);

    @Nullable
    public String itemId(ItemStack var1);

    public CompletableFuture<Void> initialized();

    default public Optional<Ingredient> getIngredient(@NotNull ItemStack itemStack) {
        return Optional.ofNullable(this.itemId(itemStack)).map(id -> new PluginIngredient(new BreweryKey(this.getId(), (String)id), this));
    }
}

