/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.integration.item;

import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.integration.ItemIntegration;
import dev.jsinco.brewery.util.ClassUtil;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.momirealms.craftengine.bukkit.api.event.CraftEngineReloadEvent;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class CraftEngineIntegration
implements ItemIntegration,
Listener {
    private static final boolean ENABLED = ClassUtil.exists("net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine");
    private CompletableFuture<Void> initializedFuture;

    @Override
    @Nullable
    public String itemId(ItemStack itemStack) {
        Key customId = BukkitCraftEngine.instance().itemManager().customItemId((Object)itemStack);
        return customId == null ? null : customId.toString();
    }

    @Override
    public CompletableFuture<Void> initialized() {
        return this.initializedFuture;
    }

    @Override
    public Optional<ItemStack> createItem(String id) {
        return Optional.ofNullable(BukkitCraftEngine.instance().itemManager().createWrappedItem(Key.from((String)id), null)).map(Item::getItem);
    }

    @Override
    @Nullable
    public Component displayName(String id) {
        return ((ItemStack)BukkitCraftEngine.instance().itemManager().buildItemStack(Key.from((String)id), null)).effectiveName();
    }

    @Override
    public boolean enabled() {
        return ENABLED;
    }

    @Override
    public String getId() {
        return "craftengine";
    }

    @Override
    public void initialize() {
        this.initializedFuture = new CompletableFuture();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)TheBrewingProject.getInstance());
    }

    @EventHandler
    public void onCraftEngineReload(CraftEngineReloadEvent ignored) {
        this.initializedFuture.completeAsync(() -> null);
    }
}

