/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.integration.placeholder;

import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.configuration.locale.TranslationsConfig;
import dev.jsinco.brewery.effect.DrunkState;
import dev.jsinco.brewery.effect.DrunkStateImpl;
import dev.jsinco.brewery.effect.DrunksManager;
import dev.jsinco.brewery.event.DrunkEvent;
import dev.jsinco.brewery.util.Pair;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderApiExpansion
extends PlaceholderExpansion {
    @NotNull
    public String getIdentifier() {
        return "tbp";
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)",", TheBrewingProject.getInstance().getPluginMeta().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return TheBrewingProject.getInstance().getPluginMeta().getVersion();
    }

    public String onRequest(@Nullable OfflinePlayer player, @NotNull String params) {
        return this.readPlayer(player, params);
    }

    public String onPlaceholderRequest(@Nullable Player player, @NotNull String params) {
        return this.readPlayer((OfflinePlayer)player, params);
    }

    private String readPlayer(OfflinePlayer player, String params) {
        if (player == null) {
            return null;
        }
        DrunksManager drunksManager = TheBrewingProject.getInstance().getDrunksManager();
        DrunkState drunkState = drunksManager.getDrunkState(player.getUniqueId());
        if (drunkState == null) {
            drunkState = new DrunkStateImpl(0, 0, TheBrewingProject.getInstance().getTime(), -1L);
        }
        return switch (params) {
            case "alcohol" -> String.valueOf(drunkState.alcohol());
            case "toxins" -> String.valueOf(drunkState.toxins());
            case "next_event" -> {
                Pair<DrunkEvent, Long> event = drunksManager.getPlannedEvent(player.getUniqueId());
                if (event == null) {
                    yield TranslationsConfig.NO_EVENT_PLANNED;
                }
                yield event.first().displayName();
            }
            default -> null;
        };
    }
}

