/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.listeners;

import dev.jsinco.brewery.breweries.BarrelType;
import dev.jsinco.brewery.breweries.InventoryAccessible;
import dev.jsinco.brewery.breweries.StructureHolder;
import dev.jsinco.brewery.bukkit.breweries.BreweryRegistry;
import dev.jsinco.brewery.bukkit.breweries.barrel.BukkitBarrel;
import dev.jsinco.brewery.bukkit.breweries.barrel.BukkitBarrelDataType;
import dev.jsinco.brewery.bukkit.breweries.distillery.BukkitDistillery;
import dev.jsinco.brewery.bukkit.breweries.distillery.BukkitDistilleryDataType;
import dev.jsinco.brewery.bukkit.listeners.ListenerUtil;
import dev.jsinco.brewery.bukkit.structure.BarrelBlockDataMatcher;
import dev.jsinco.brewery.bukkit.structure.BreweryStructure;
import dev.jsinco.brewery.bukkit.structure.GenericBlockDataMatcher;
import dev.jsinco.brewery.bukkit.structure.PlacedBreweryStructure;
import dev.jsinco.brewery.bukkit.structure.StructureRegistry;
import dev.jsinco.brewery.bukkit.util.BukkitAdapter;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.configuration.locale.TranslationsConfig;
import dev.jsinco.brewery.database.PersistenceException;
import dev.jsinco.brewery.database.sql.Database;
import dev.jsinco.brewery.structure.MultiblockStructure;
import dev.jsinco.brewery.structure.PlacedStructureRegistryImpl;
import dev.jsinco.brewery.structure.StructureMeta;
import dev.jsinco.brewery.structure.StructureType;
import dev.jsinco.brewery.util.Logger;
import dev.jsinco.brewery.util.MessageUtil;
import dev.jsinco.brewery.util.Pair;
import dev.jsinco.brewery.vector.BreweryLocation;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.ExplosionResult;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.inventory.HopperInventorySearchEvent;

public class BlockEventListener
implements Listener {
    private final StructureRegistry structureRegistry;
    private final PlacedStructureRegistryImpl placedStructureRegistry;
    private final Database database;
    private final BreweryRegistry breweryRegistry;

    public BlockEventListener(StructureRegistry structureRegistry, PlacedStructureRegistryImpl placedStructureRegistry, Database database, BreweryRegistry breweryRegistry) {
        this.structureRegistry = structureRegistry;
        this.placedStructureRegistry = placedStructureRegistry;
        this.database = database;
        this.breweryRegistry = breweryRegistry;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignChangeEvent(SignChangeEvent event) {
        String[] lines = event.getLines();
        if (!("barrel".equalsIgnoreCase(lines[0]) && lines[1].isEmpty() && lines[2].isEmpty() && lines[3].isEmpty())) {
            return;
        }
        BlockData blockData = event.getBlock().getBlockData();
        if (!(blockData instanceof WallSign)) {
            return;
        }
        WallSign wallSign = (WallSign)blockData;
        Optional<Pair<PlacedBreweryStructure<BukkitBarrel>, BarrelType>> possibleStructure = this.getBarrel(event.getBlock().getRelative(wallSign.getFacing().getOppositeFace()));
        if (possibleStructure.isEmpty()) {
            return;
        }
        Pair<PlacedBreweryStructure<BukkitBarrel>, BarrelType> placedStructurePair = possibleStructure.get();
        PlacedBreweryStructure<BukkitBarrel> placedBreweryStructure = placedStructurePair.first();
        if (!this.placedStructureRegistry.getStructures(placedBreweryStructure.positions()).isEmpty()) {
            return;
        }
        if (!event.getPlayer().hasPermission("brewery.barrel.create")) {
            MessageUtil.message((Audience)event.getPlayer(), TranslationsConfig.BARREL_CREATE_DENIED, new TagResolver[0]);
            return;
        }
        MessageUtil.message((Audience)event.getPlayer(), TranslationsConfig.BARREL_CREATE, new TagResolver[0]);
        BukkitBarrel barrel = new BukkitBarrel(BukkitAdapter.toLocation(placedBreweryStructure.getUnique()), placedBreweryStructure, placedBreweryStructure.getStructure().getMeta(StructureMeta.INVENTORY_SIZE), placedStructurePair.second());
        placedBreweryStructure.setHolder(barrel);
        this.placedStructureRegistry.registerStructure(placedBreweryStructure);
        this.breweryRegistry.registerInventory(barrel);
        try {
            this.database.insertValue(BukkitBarrelDataType.INSTANCE, barrel);
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent placeEvent) {
        Block placed = placeEvent.getBlockPlaced();
        for (BreweryStructure breweryStructure : this.structureRegistry.getPossibleStructures(placed.getType(), StructureType.DISTILLERY)) {
            Optional placedBreweryStructureOptional = PlacedBreweryStructure.findValid(breweryStructure, placed.getLocation(), GenericBlockDataMatcher.INSTANCE, new Void[1]);
            if (!placedBreweryStructureOptional.isPresent() || !this.placedStructureRegistry.getStructures(placedBreweryStructureOptional.get().first().positions()).isEmpty()) continue;
            Player player = placeEvent.getPlayer();
            if (!player.hasPermission("brewery.distillery.create")) {
                MessageUtil.message((Audience)player, TranslationsConfig.DISTILLERY_CREATE_DENIED, new TagResolver[0]);
                return;
            }
            this.registerDistillery(placedBreweryStructureOptional.get().first());
            MessageUtil.message((Audience)player, TranslationsConfig.DISTILLERY_CREATE, new TagResolver[0]);
            return;
        }
    }

    private void registerDistillery(PlacedBreweryStructure<BukkitDistillery> distilleryPlacedBreweryStructure) {
        BukkitDistillery bukkitDistillery = new BukkitDistillery(distilleryPlacedBreweryStructure);
        distilleryPlacedBreweryStructure.setHolder(bukkitDistillery);
        this.placedStructureRegistry.registerStructure(distilleryPlacedBreweryStructure);
        try {
            this.database.insertValue(BukkitDistilleryDataType.INSTANCE, bukkitDistillery);
            this.breweryRegistry.registerInventory(bukkitDistillery);
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
    }

    private Optional<Pair<PlacedBreweryStructure<BukkitBarrel>, BarrelType>> getBarrel(Block block) {
        Location placedLocation = block.getLocation();
        Material material = block.getType();
        Set<BreweryStructure> possibleStructures = this.structureRegistry.getPossibleStructures(material, StructureType.BARREL);
        for (BreweryStructure structure : possibleStructures) {
            Optional<Pair<PlacedBreweryStructure<BukkitBarrel>, BarrelType>> placedBreweryStructure = PlacedBreweryStructure.findValid(structure, placedLocation, BarrelBlockDataMatcher.INSTANCE, BarrelType.PLACEABLE_TYPES);
            if (!placedBreweryStructure.isPresent()) continue;
            return placedBreweryStructure;
        }
        return Optional.empty();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        this.destroyFromBlock(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        this.onMultiBlockRemove(event.getBlocks().stream().map(Block::getLocation).toList());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        this.onMultiBlockRemove(event.getBlocks().stream().map(Block::getLocation).toList());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (event.getExplosionResult() == ExplosionResult.TRIGGER_BLOCK) {
            return;
        }
        this.onMultiBlockRemove(event.blockList().stream().map(Block::getLocation).toList());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent event) {
        if (event.getExplosionResult() == ExplosionResult.TRIGGER_BLOCK) {
            return;
        }
        this.onMultiBlockRemove(event.blockList().stream().map(Block::getLocation).toList());
    }

    private void onMultiBlockRemove(List<Location> locationList) {
        HashSet multiblockStructures = new HashSet();
        HashSet holders = new HashSet();
        for (Location location : locationList) {
            BreweryLocation breweryLocation = BukkitAdapter.toBreweryLocation(location);
            this.placedStructureRegistry.getHolder(breweryLocation).ifPresent(holder -> {
                holders.add(holder);
                multiblockStructures.add(holder.getStructure());
                if (holder instanceof InventoryAccessible) {
                    InventoryAccessible inventoryAccessible = (InventoryAccessible)((Object)holder);
                    this.breweryRegistry.unregisterInventory(inventoryAccessible);
                }
            });
            this.breweryRegistry.getActiveSinglePositionStructure(breweryLocation).ifPresent(cauldron -> ListenerUtil.removeActiveSinglePositionStructure(cauldron, this.breweryRegistry, this.database));
        }
        multiblockStructures.forEach(this.placedStructureRegistry::unregisterStructure);
        for (StructureHolder holder2 : holders) {
            holder2.destroy(BukkitAdapter.toBreweryLocation(locationList.getFirst()));
            this.remove(holder2);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        this.destroyFromBlock(event.getBlock());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        this.destroyFromBlock(event.getBlock());
    }

    @EventHandler(ignoreCancelled=true)
    public void onHopperInventorySearch(HopperInventorySearchEvent event) {
        Block searchBlock = event.getSearchBlock();
        BreweryLocation breweryLocation = BukkitAdapter.toBreweryLocation(searchBlock);
        Optional<InventoryAccessible> inventoryAccessibleOptional = this.placedStructureRegistry.getStructure(breweryLocation).map(MultiblockStructure::getHolder).filter(InventoryAccessible.class::isInstance).map(inventoryAccessible -> (InventoryAccessible)((Object)inventoryAccessible));
        if (!Config.config().automation()) {
            inventoryAccessibleOptional.ifPresent(ignored -> event.setInventory(null));
            return;
        }
        inventoryAccessibleOptional.flatMap(inventoryAccessible -> inventoryAccessible.access(breweryLocation)).ifPresent(arg_0 -> ((HopperInventorySearchEvent)event).setInventory(arg_0));
    }

    private void destroyFromBlock(Block block) {
        BreweryLocation breweryLocation = BukkitAdapter.toBreweryLocation(block);
        Optional<MultiblockStructure<?>> multiBlockStructure = this.placedStructureRegistry.getStructure(breweryLocation);
        multiBlockStructure.ifPresent(this.placedStructureRegistry::unregisterStructure);
        multiBlockStructure.map(MultiblockStructure::getHolder).ifPresent(holder -> {
            holder.destroy(breweryLocation);
            this.remove((StructureHolder<?>)holder);
            if (holder instanceof InventoryAccessible) {
                InventoryAccessible inventoryAccessible = (InventoryAccessible)((Object)holder);
                this.breweryRegistry.unregisterInventory(inventoryAccessible);
            }
        });
        this.breweryRegistry.getActiveSinglePositionStructure(breweryLocation).ifPresent(cauldron -> ListenerUtil.removeActiveSinglePositionStructure(cauldron, this.breweryRegistry, this.database));
    }

    private void remove(StructureHolder<?> holder) {
        try {
            if (holder instanceof BukkitBarrel) {
                BukkitBarrel barrel = (BukkitBarrel)holder;
                this.database.remove(BukkitBarrelDataType.INSTANCE, barrel);
            }
            if (holder instanceof BukkitDistillery) {
                BukkitDistillery distillery = (BukkitDistillery)holder;
                this.database.remove(BukkitDistilleryDataType.INSTANCE, distillery);
            }
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
    }
}

