/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.recipe;

import dev.jsinco.brewery.brew.Brew;
import dev.jsinco.brewery.brew.BrewScore;
import dev.jsinco.brewery.brew.BrewingStep;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.brew.BrewAdapter;
import dev.jsinco.brewery.bukkit.integration.Integration;
import dev.jsinco.brewery.bukkit.integration.IntegrationType;
import dev.jsinco.brewery.bukkit.recipe.RecipeEffects;
import dev.jsinco.brewery.bukkit.util.BukkitAdapter;
import dev.jsinco.brewery.configuration.locale.TranslationsConfig;
import dev.jsinco.brewery.recipe.RecipeResult;
import dev.jsinco.brewery.util.BreweryKey;
import dev.jsinco.brewery.util.Logger;
import dev.jsinco.brewery.util.MessageUtil;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import io.papermc.paper.datacomponent.item.ItemEnchantments;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.datacomponent.item.PotionContents;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitRecipeResult
implements RecipeResult<ItemStack> {
    @NotNull
    public static final RecipeResult<ItemStack> GENERIC = new Builder().lore(List.of()).name("Generic").recipeEffects(RecipeEffects.GENERIC).build();
    private final boolean glint;
    private final int customModelData;
    @Nullable
    private final NamespacedKey itemModel;
    @Nullable
    private final BreweryKey customId;
    private final String name;
    private final List<String> lore;
    private final RecipeEffects recipeEffects;
    private final Color color;
    private final boolean appendBrewInfoLore;

    private BukkitRecipeResult(boolean glint, int customModelData, @Nullable NamespacedKey itemModel, RecipeEffects recipeEffects, String name, List<String> lore, Color color, boolean appendBrewInfoLore, @Nullable BreweryKey customId) {
        this.glint = glint;
        this.customModelData = customModelData;
        this.itemModel = itemModel;
        this.recipeEffects = recipeEffects;
        this.name = name;
        this.lore = lore;
        this.color = color;
        this.appendBrewInfoLore = appendBrewInfoLore;
        this.customId = customId;
    }

    @Override
    public ItemStack newBrewItem(@NotNull BrewScore score, @NotNull Brew brew, @NotNull Brew.State state) {
        ItemStack itemStack;
        if (this.customId != null) {
            itemStack = this.createCustomItem();
            if (itemStack != null) {
                this.applyData(itemStack, score, brew, state);
                return itemStack;
            }
            Logger.logErr("Invalid item id '" + String.valueOf(this.customId) + "' for recipe: " + this.name);
        }
        itemStack = new ItemStack(Material.POTION);
        this.applyData(itemStack, score, brew, state);
        return itemStack;
    }

    @Nullable
    private ItemStack createCustomItem() {
        if (this.customId.namespace().equals("minecraft")) {
            ItemType itemType = (ItemType)Registry.ITEM.get(BukkitAdapter.toNamespacedKey(this.customId));
            if (itemType == null || itemType == ItemType.AIR) {
                return null;
            }
            return itemType.createItemStack();
        }
        return TheBrewingProject.getInstance().getIntegrationManager().getIntegrationRegistry().getIntegrations(IntegrationType.ITEM).stream().filter(Integration::enabled).filter(integration -> this.customId.namespace().equals(integration.getId())).findAny().orElseThrow(() -> new IllegalStateException("Namespace should be within the supported items plugins")).createItem(this.customId.key()).orElse(null);
    }

    private void applyData(ItemStack itemStack, BrewScore score, Brew brew, Brew.State state) {
        BrewAdapter.hideTooltips(itemStack);
        itemStack.setData(DataComponentTypes.CUSTOM_NAME, (Object)this.compileMessage(score, brew, this.name, true).decoration(TextDecoration.ITALIC, false));
        itemStack.setData(DataComponentTypes.LORE, (Object)ItemLore.lore(Stream.concat(this.lore.stream().map(line -> this.compileMessage(score, brew, (String)line, false)), this.compileExtraLore(score, brew, state)).map(component -> component.decoration(TextDecoration.ITALIC, false)).map(component -> component.colorIfAbsent((TextColor)NamedTextColor.GRAY)).toList()));
        if (this.glint) {
            itemStack.setData(DataComponentTypes.ENCHANTMENTS, (DataComponentBuilder)ItemEnchantments.itemEnchantments().add(Enchantment.MENDING, 1));
        }
        if (this.customModelData > 0) {
            itemStack.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)CustomModelData.customModelData().addFloat((float)this.customModelData).build()));
        }
        if (this.itemModel != null) {
            itemStack.setData(DataComponentTypes.ITEM_MODEL, (Object)this.itemModel);
        }
        this.recipeEffects.withToxins(this.recipeEffects, (int)((double)this.recipeEffects.getAlcohol() * (1.5 - score.score()))).applyTo(itemStack);
        itemStack.setData(DataComponentTypes.POTION_CONTENTS, (DataComponentBuilder)PotionContents.potionContents().addCustomEffects(((PotionContents)itemStack.getData(DataComponentTypes.POTION_CONTENTS)).customEffects()).customColor(this.color));
    }

    private Stream<? extends Component> compileExtraLore(BrewScore score, Brew brew, Brew.State state) {
        if (!this.appendBrewInfoLore) {
            return Stream.empty();
        }
        Stream.Builder<Component> streamBuilder = Stream.builder();
        streamBuilder.add((Component)Component.empty());
        Brew.State state2 = state;
        Objects.requireNonNull(state2);
        Brew.State state3 = state2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Brew.State.Brewing.class, Brew.State.Other.class, Brew.State.Seal.class}, (Object)state3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Brew.State.Brewing ignored = (Brew.State.Brewing)state3;
                streamBuilder.add(this.compileMessage(score, brew, TranslationsConfig.BREW_TOOLTIP_QUALITY_BREWING, false));
                MessageUtil.compileBrewInfo(brew, score, false).forEach(streamBuilder::add);
                int alcohol = this.recipeEffects.getAlcohol();
                if (alcohol <= 0) break;
                streamBuilder.add(MessageUtil.miniMessage(TranslationsConfig.DETAILED_ALCOHOLIC, Formatter.number((String)"alcohol", (Number)alcohol)));
                break;
            }
            case 1: {
                Brew.State.Other ignored = (Brew.State.Other)state3;
                streamBuilder.add(this.compileMessage(score, brew, TranslationsConfig.BREW_TOOLTIP_QUALITY, false));
                this.addLastStepLore(brew, streamBuilder, score, false);
                break;
            }
            case 2: {
                Brew.State.Seal seal = (Brew.State.Seal)state3;
                if (seal.message() != null) {
                    streamBuilder.add(MessageUtil.miniMessage(TranslationsConfig.BREW_TOOLTIP_VOLUME, new TagResolver[]{Placeholder.parsed((String)"volume", (String)seal.message())}));
                }
                streamBuilder.add(MessageUtil.miniMessage(TranslationsConfig.BREW_TOOLTIP_QUALITY_SEALED, MessageUtil.getScoreTagResolver(score)));
                this.addLastStepLore(brew, streamBuilder, score, true);
            }
        }
        return streamBuilder.build();
    }

    private void addLastStepLore(Brew brew, Stream.Builder<Component> streamBuilder, BrewScore score, boolean sealed) {
        Map<String, String> lore = sealed ? TranslationsConfig.BREW_TOOLTIP_SEALED : TranslationsConfig.BREW_TOOLTIP;
        BrewingStep brewingStep = brew.lastCompletedStep();
        streamBuilder.add(MessageUtil.miniMessage(lore.get(brewingStep.stepType().name().toLowerCase(Locale.ROOT)), MessageUtil.getBrewStepTagResolver(brewingStep, score.getPartialScores(brew.getCompletedSteps().size() - 1), score.brewDifficulty())));
        if (this.recipeEffects.getAlcohol() > 0) {
            streamBuilder.add(MessageUtil.miniMessage(TranslationsConfig.ALCOHOLIC, new TagResolver[0]));
        }
    }

    private Component compileMessage(BrewScore score, Brew brew, String serializedMiniMessage, boolean isBrewName) {
        return MessageUtil.miniMessage(serializedMiniMessage, this.getResolver(score, brew, isBrewName));
    }

    @NotNull
    private TagResolver getResolver(BrewScore score, Brew brew, boolean isBrewName) {
        TagResolver.Builder output = TagResolver.builder();
        if (!isBrewName) {
            output.resolver((TagResolver)Placeholder.component((String)"brew_name", (ComponentLike)this.compileMessage(score, brew, this.name, true)));
        }
        output.resolvers(new TagResolver[]{Formatter.number((String)"alcohol", (Number)this.getRecipeEffects().getAlcohol()), MessageUtil.getScoreTagResolver(score)});
        return output.build();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getLore() {
        return this.lore;
    }

    @Generated
    public RecipeEffects getRecipeEffects() {
        return this.recipeEffects;
    }

    @Generated
    public Color getColor() {
        return this.color;
    }

    public static class Builder {
        private boolean glint;
        private int customModelData;
        private NamespacedKey itemModel;
        private String name;
        private List<String> lore;
        private RecipeEffects recipeEffects;
        private Color color = Color.BLUE;
        private boolean appendBrewInfoLore = true;
        private BreweryKey customId;

        public Builder glint(boolean glint) {
            this.glint = glint;
            return this;
        }

        public Builder customModelData(int customModelData) {
            this.customModelData = customModelData;
            return this;
        }

        public Builder itemModel(@Nullable String itemModel) {
            if (itemModel != null) {
                this.itemModel = NamespacedKey.fromString((String)itemModel);
                if (this.itemModel == null) {
                    throw new IllegalArgumentException("Illegal namespaced key");
                }
            }
            return this;
        }

        public Builder recipeEffects(@NotNull RecipeEffects recipeEffects) {
            this.recipeEffects = Objects.requireNonNull(recipeEffects);
            return this;
        }

        public Builder color(@NotNull Color color) {
            this.color = color;
            return this;
        }

        public Builder appendBrewInfoLore(boolean appendBrewInfoLore) {
            this.appendBrewInfoLore = appendBrewInfoLore;
            return this;
        }

        public Builder customId(@Nullable String customId) {
            if (customId == null) {
                this.customId = null;
                return this;
            }
            BreweryKey namespacedKey = BreweryKey.parse(customId.toLowerCase(Locale.ROOT), "minecraft");
            List<String> ids = TheBrewingProject.getInstance().getIntegrationManager().retrieve(IntegrationType.ITEM).stream().map(Integration::getId).toList();
            if (ids.contains(namespacedKey.namespace()) || "minecraft".equals(namespacedKey.namespace())) {
                this.customId = namespacedKey;
                return this;
            }
            throw new IllegalArgumentException("Unknown key, can not identify namespace: " + String.valueOf(namespacedKey));
        }

        public BukkitRecipeResult build() {
            Objects.requireNonNull(this.name, "Names not initialized, a recipe has to have names");
            Objects.requireNonNull(this.lore, "Lore not initialized, a recipe has to have lore");
            Objects.requireNonNull(this.recipeEffects, "Effects not initialized, a recipe has to have effects");
            return new BukkitRecipeResult(this.glint, this.customModelData, this.itemModel, this.recipeEffects, this.name, this.lore, this.color, this.appendBrewInfoLore, this.customId);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder lore(List<String> lore) {
            this.lore = lore;
            return this;
        }
    }
}

