/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.structure;

import dev.jsinco.brewery.breweries.StructureHolder;
import dev.jsinco.brewery.bukkit.structure.BlockDataMatcher;
import dev.jsinco.brewery.bukkit.structure.BreweryStructure;
import dev.jsinco.brewery.structure.MultiblockStructure;
import dev.jsinco.brewery.util.Pair;
import dev.jsinco.brewery.vector.BreweryLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Location;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3d;

public class PlacedBreweryStructure<H extends StructureHolder<H>>
implements MultiblockStructure<H> {
    private static final List<Matrix3d> ALLOWED_TRANSFORMATIONS = PlacedBreweryStructure.compileAllowedTransformations();
    private final BreweryStructure structure;
    private final Matrix3d transformation;
    private final Location worldOrigin;
    private final BreweryLocation unique;
    @Nullable
    private H holder = null;

    public PlacedBreweryStructure(BreweryStructure structure, Matrix3d transformation, Location worldOrigin) {
        this.structure = structure;
        this.transformation = transformation;
        this.worldOrigin = worldOrigin;
        this.unique = this.compileUnique();
    }

    public static <T, H extends StructureHolder<H>> Optional<Pair<PlacedBreweryStructure<H>, T>> findValid(BreweryStructure structure, Location worldOrigin, BlockDataMatcher<T> blockDataMatcher, T[] types) {
        for (Matrix3d transformation : ALLOWED_TRANSFORMATIONS) {
            for (Object type : types) {
                Optional<Location> possibleOrigin = structure.findValidOrigin(transformation, worldOrigin, blockDataMatcher, type);
                if (!possibleOrigin.isPresent()) continue;
                return possibleOrigin.map(origin -> new Pair(new PlacedBreweryStructure(structure, transformation, (Location)origin), type));
            }
        }
        return Optional.empty();
    }

    @Override
    public List<BreweryLocation> positions() {
        return this.structure.getExpectedBlocks(this.transformation, this.worldOrigin).keySet().stream().map(location -> new BreweryLocation(location.getBlockX(), location.getBlockY(), location.getBlockZ(), location.getWorld().getUID())).toList();
    }

    @Override
    public BreweryLocation getUnique() {
        return this.unique;
    }

    private BreweryLocation compileUnique() {
        ArrayList<BreweryLocation> positions = new ArrayList<BreweryLocation>(this.positions());
        positions.sort(this::comparePositions);
        return (BreweryLocation)positions.getFirst();
    }

    private static List<Matrix3d> compileAllowedTransformations() {
        int i;
        ArrayList<Matrix3d> output = new ArrayList<Matrix3d>();
        Matrix3d transformation = new Matrix3d();
        for (i = 0; i < 4; ++i) {
            output.add(transformation.rotate(1.5707963267948966 * (double)i, 0.0, 1.0, 0.0, new Matrix3d()));
        }
        transformation.reflect(1.0, 0.0, 0.0);
        for (i = 0; i < 4; ++i) {
            output.add(transformation.rotate(1.5707963267948966 * (double)i, 0.0, 1.0, 0.0, new Matrix3d()));
        }
        return List.copyOf(output);
    }

    private int comparePositions(BreweryLocation breweryLocation, BreweryLocation breweryLocation1) {
        if (breweryLocation.y() > breweryLocation1.y()) {
            return -1;
        }
        if (breweryLocation.x() > breweryLocation1.x()) {
            return -1;
        }
        if (breweryLocation.z() > breweryLocation1.z()) {
            return -1;
        }
        return 0;
    }

    @Generated
    public BreweryStructure getStructure() {
        return this.structure;
    }

    @Generated
    public Matrix3d getTransformation() {
        return this.transformation;
    }

    @Generated
    public Location getWorldOrigin() {
        return this.worldOrigin;
    }

    @Override
    @Generated
    public void setHolder(@Nullable H holder) {
        this.holder = holder;
    }

    @Override
    @Nullable
    @Generated
    public H getHolder() {
        return this.holder;
    }
}

