/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.util;

import dev.jsinco.brewery.util.BreweryKey;
import dev.jsinco.brewery.util.Holder;
import dev.jsinco.brewery.vector.BreweryLocation;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitAdapter {
    public static Location toLocation(BreweryLocation location) {
        return new Location(Bukkit.getWorld((UUID)location.worldUuid()), (double)location.x(), (double)location.y(), (double)location.z());
    }

    public static BreweryLocation toBreweryLocation(Location location) {
        return new BreweryLocation(location.getBlockX(), location.getBlockY(), location.getBlockZ(), location.getWorld().getUID());
    }

    public static BreweryLocation toBreweryLocation(Block block) {
        return new BreweryLocation(block.getX(), block.getY(), block.getZ(), block.getWorld().getUID());
    }

    public static Block toBlock(BreweryLocation location) {
        return Bukkit.getWorld((UUID)location.worldUuid()).getBlockAt(location.x(), location.y(), location.z());
    }

    public static NamespacedKey toNamespacedKey(BreweryKey breweryKey) {
        return NamespacedKey.fromString((String)breweryKey.toString());
    }

    public static BreweryKey toBreweryKey(NamespacedKey namespacedKey) {
        return new BreweryKey(namespacedKey.namespace(), namespacedKey.getKey());
    }

    public static Optional<World> toWorld(BreweryLocation location) {
        return Optional.ofNullable(Bukkit.getWorld((UUID)location.worldUuid()));
    }

    @Nullable
    public static Location parseLocation(String teleport) {
        String[] split = teleport.split(",");
        World world = Bukkit.getWorld((String)split[0]);
        if (world == null) {
            return null;
        }
        int x = Integer.parseInt(split[1].strip());
        int y = Integer.parseInt(split[2].strip());
        int z = Integer.parseInt(split[3].strip());
        return new Location(world, (double)x, (double)y, (double)z);
    }

    @Nullable
    public static Material toMaterial(Holder.Material material) {
        return (Material)Registry.MATERIAL.get(BukkitAdapter.toNamespacedKey(material.value()));
    }

    @NotNull
    public static Holder.Material toMaterialHolder(Material material) {
        return new Holder.Material(BukkitAdapter.toBreweryKey(material.getKey()));
    }
}

