/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.util;

import dev.jsinco.brewery.brew.BrewingStep;
import dev.jsinco.brewery.bukkit.brew.BrewingStepPdcType;
import dev.jsinco.brewery.bukkit.util.StringPdcType;
import dev.jsinco.brewery.util.DecoderEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class ListPersistentDataType<T>
implements PersistentDataType<byte[], List<T>> {
    private final PersistentDataType<byte[], T> persistentDataType;
    public static final ListPersistentDataType<String> STRING_LIST = new ListPersistentDataType<String>(new StringPdcType());
    public static final ListPersistentDataType<BrewingStep> BREWING_STEP_LIST = new ListPersistentDataType<BrewingStep>(new BrewingStepPdcType());

    public ListPersistentDataType(PersistentDataType<byte[], T> persistentDataType) {
        this.persistentDataType = persistentDataType;
    }

    @NotNull
    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    @NotNull
    public Class<List<T>> getComplexType() {
        return List.of().getClass();
    }

    public byte @NotNull [] toPrimitive(@NotNull List<T> complex, @NotNull PersistentDataAdapterContext context) {
        byte[] byArray;
        byte[][] byteArrayArray = (byte[][])complex.stream().map(complexElement -> (byte[])this.persistentDataType.toPrimitive(complexElement, context)).toArray(x$0 -> new byte[x$0][]);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(output);
        try {
            DecoderEncoder.encode(byteArrayArray, outputStream);
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        outputStream.close();
        return byArray;
    }

    @NotNull
    public List<T> fromPrimitive(byte @NotNull [] primitive, @NotNull PersistentDataAdapterContext context) {
        try {
            byte[][] byteArrayArray = DecoderEncoder.decode(new ByteArrayInputStream(primitive));
            return Arrays.stream(byteArrayArray).map(primitiveElement -> this.persistentDataType.fromPrimitive(primitiveElement, context)).toList();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

