/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration.serializers;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.event.EventStep;
import dev.jsinco.brewery.event.EventStepProperty;
import dev.jsinco.brewery.event.NamedDrunkEvent;
import dev.jsinco.brewery.event.step.ApplyPotionEffect;
import dev.jsinco.brewery.event.step.ConditionalWaitStep;
import dev.jsinco.brewery.event.step.ConsumeStep;
import dev.jsinco.brewery.event.step.CustomEventStep;
import dev.jsinco.brewery.event.step.SendCommand;
import dev.jsinco.brewery.event.step.Teleport;
import dev.jsinco.brewery.event.step.WaitStep;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import dev.jsinco.brewery.moment.Interval;
import dev.jsinco.brewery.util.BreweryKey;
import dev.jsinco.brewery.util.Registry;
import dev.jsinco.brewery.vector.BreweryLocation;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;

public class EventStepSerializer
implements ObjectSerializer<EventStep> {
    @Override
    public boolean supports(@NonNull Class<? super EventStep> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return EventStep.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NonNull EventStep object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        HashMap<String, BreweryLocation.Uncompiled> output = new HashMap<String, BreweryLocation.Uncompiled>();
        for (EventStepProperty property : object.properties()) {
            EventStepProperty eventStepProperty;
            Objects.requireNonNull(property);
            int n = 0;
            output.putAll(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ApplyPotionEffect.class, ConditionalWaitStep.class, ConsumeStep.class, CustomEventStep.class, NamedDrunkEvent.class, SendCommand.class, Teleport.class, WaitStep.class}, (Object)eventStepProperty, n)) {
                case 0 -> {
                    ApplyPotionEffect applyPotionEffect = (ApplyPotionEffect)eventStepProperty;
                    yield Map.of("effect", applyPotionEffect.potionEffectName(), "duration", applyPotionEffect.durationBounds().asString(), "amplifier", applyPotionEffect.amplifierBounds().asString());
                }
                case 1 -> {
                    ConditionalWaitStep conditionalWaitStep = (ConditionalWaitStep)eventStepProperty;
                    yield Map.of("condition", conditionalWaitStep.condition().toString().toLowerCase(Locale.ROOT));
                }
                case 2 -> {
                    ConsumeStep consumeStep = (ConsumeStep)eventStepProperty;
                    yield Map.of("alcohol", consumeStep.alcohol(), "toxins", consumeStep.toxins());
                }
                case 3 -> {
                    CustomEventStep customEvent = (CustomEventStep)eventStepProperty;
                    yield Map.of("event", customEvent.customEventKey().key());
                }
                case 4 -> {
                    NamedDrunkEvent namedDrunkEvent = (NamedDrunkEvent)eventStepProperty;
                    yield Map.of("named-event", namedDrunkEvent.key().key());
                }
                case 5 -> {
                    SendCommand sendCommand = (SendCommand)eventStepProperty;
                    yield Map.of("as", sendCommand.senderType().toString().toLowerCase(Locale.ROOT), "command", sendCommand.command());
                }
                case 6 -> {
                    Teleport teleport = (Teleport)eventStepProperty;
                    yield Map.of("location", teleport.location());
                }
                case 7 -> {
                    WaitStep waitStep = (WaitStep)eventStepProperty;
                    yield Map.of("wait-duration", waitStep.durationTicks() + "t");
                }
                default -> throw new IllegalArgumentException("Unsupported event step: " + String.valueOf(property));
            });
        }
        data.setValue(output);
    }

    @Override
    public EventStep deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        EventStep eventStep;
        String duration;
        NamedDrunkEvent namedDrunkEvent;
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        EventStep.Builder eventStepBuilder = new EventStep.Builder();
        if (data.containsKey("type") && (namedDrunkEvent = Registry.DRUNK_EVENT.get(BreweryKey.parse(data.get("type", String.class)))) != null) {
            eventStepBuilder.addProperty(namedDrunkEvent);
        }
        if (data.containsKey("named-event")) {
            String string = data.get("named-event", String.class);
            NamedDrunkEvent namedDrunkEvent2 = Registry.DRUNK_EVENT.get(BreweryKey.parse(string));
            Preconditions.checkArgument((namedDrunkEvent2 != null ? 1 : 0) != 0, (Object)("Unknown predefined drunk event: " + string));
            eventStepBuilder.addProperty(namedDrunkEvent2);
        }
        if (data.containsKey("event")) {
            namedDrunkEvent = Registry.DRUNK_EVENT.get(BreweryKey.parse(data.get("event", String.class)));
            eventStepBuilder.addProperty(namedDrunkEvent != null ? namedDrunkEvent : new CustomEventStep(BreweryKey.parse(data.get("event", String.class))));
        }
        if (data.containsKey("command")) {
            SendCommand.CommandSenderType senderType = data.get("as", SendCommand.CommandSenderType.class);
            String command = data.get("command", String.class);
            Preconditions.checkArgument((command != null ? 1 : 0) != 0, (Object)"Command can not be empty");
            eventStepBuilder.addProperty(new SendCommand(command, senderType == null ? SendCommand.CommandSenderType.SERVER : senderType));
        }
        if (data.containsKey("condition")) {
            ConditionalWaitStep.Condition condition = data.get("condition", ConditionalWaitStep.Condition.class);
            Preconditions.checkArgument((condition != null ? 1 : 0) != 0, (Object)"Condition can not be empty");
            eventStepBuilder.addProperty(new ConditionalWaitStep(condition));
        }
        if (data.containsKey("duration") && !data.containsKey("effect")) {
            duration = data.get("duration", String.class);
            Preconditions.checkArgument((duration != null ? 1 : 0) != 0, (Object)"Duration can not be empty");
            eventStepBuilder.addProperty(WaitStep.parse(duration));
        }
        if (data.containsKey("wait-duration")) {
            duration = data.get("wait-duration", String.class);
            Preconditions.checkArgument((duration != null ? 1 : 0) != 0, (Object)"Duration can not be empty");
            eventStepBuilder.addProperty(WaitStep.parse(duration));
        }
        if (data.containsKey("effect")) {
            String effect = data.get("effect", String.class);
            Interval amplifier = data.get("amplifier", Interval.class);
            Interval duration2 = data.get("duration", Interval.class);
            eventStepBuilder.addProperty(new ApplyPotionEffect(effect, amplifier == null ? new Interval(1L, 1L) : amplifier, duration2 == null ? new Interval(200L, 200L) : duration2));
        }
        if (data.containsKey("alcohol") || data.containsKey("toxins")) {
            Integer alcohol = data.get("alcohol", Integer.class);
            Integer toxins = data.get("toxins", Integer.class);
            eventStepBuilder.addProperty(new ConsumeStep(alcohol == null ? 0 : alcohol, toxins == null ? 0 : toxins));
        }
        if (data.containsKey("location")) {
            BreweryLocation.Uncompiled breweryLocation = data.get("location", BreweryLocation.Uncompiled.class);
            Preconditions.checkArgument((breweryLocation != null ? 1 : 0) != 0, (Object)"Location can not be empty");
            eventStepBuilder.addProperty(new Teleport(breweryLocation));
        }
        if ((eventStep = eventStepBuilder.build()).properties().isEmpty()) {
            throw new IllegalArgumentException("Unknown step type");
        }
        return eventStep;
    }
}

