/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.effect;

import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.database.PersistenceException;
import dev.jsinco.brewery.database.PersistenceHandler;
import dev.jsinco.brewery.effect.DrunkStateDataType;
import dev.jsinco.brewery.effect.DrunkStateImpl;
import dev.jsinco.brewery.effect.DrunksManager;
import dev.jsinco.brewery.event.CustomEventRegistry;
import dev.jsinco.brewery.event.DrunkEvent;
import dev.jsinco.brewery.util.BreweryKey;
import dev.jsinco.brewery.util.Logger;
import dev.jsinco.brewery.util.Pair;
import dev.jsinco.brewery.util.RandomUtil;
import dev.jsinco.brewery.util.Registry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrunksManagerImpl<C>
implements DrunksManager {
    private final CustomEventRegistry eventRegistry;
    private final PersistenceHandler<C> persistenceHandler;
    private final DrunkStateDataType<C> drunkStateDataType;
    private Set<BreweryKey> allowedEvents;
    private Map<UUID, DrunkStateImpl> drunks = new HashMap<UUID, DrunkStateImpl>();
    private LongSupplier timeSupplier;
    private Map<Long, Map<UUID, DrunkEvent>> events = new HashMap<Long, Map<UUID, DrunkEvent>>();
    private Map<UUID, Long> plannedEvents = new HashMap<UUID, Long>();
    private static final Random RANDOM = new Random();

    public DrunksManagerImpl(CustomEventRegistry registry, Set<BreweryKey> allowedEvents, LongSupplier timeSupplier, PersistenceHandler<C> persistenceHandler, DrunkStateDataType<C> drunkStateDataType) {
        this.eventRegistry = registry;
        this.allowedEvents = allowedEvents;
        this.timeSupplier = timeSupplier;
        this.persistenceHandler = persistenceHandler;
        this.drunkStateDataType = drunkStateDataType;
        this.loadDrunkStates();
    }

    private void loadDrunkStates() {
        try {
            this.persistenceHandler.retrieveAllNow(this.drunkStateDataType).forEach(pair -> this.drunks.put((UUID)pair.second(), (DrunkStateImpl)pair.first()));
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
    }

    @Override
    @Nullable
    public DrunkStateImpl consume(UUID playerUuid, int alcohol, int toxins) {
        return this.consume(playerUuid, alcohol, toxins, this.timeSupplier.getAsLong());
    }

    @Nullable
    public DrunkStateImpl consume(UUID playerUuid, int alcohol, int toxins, long timestamp) {
        DrunkStateImpl drunkState;
        boolean alreadyDrunk = this.drunks.containsKey(playerUuid);
        DrunkStateImpl drunkStateImpl = drunkState = alreadyDrunk ? this.drunks.get(playerUuid).recalculate(timestamp).addAlcohol(alcohol, toxins) : new DrunkStateImpl(alcohol, toxins, timestamp, -1L);
        if (drunkState.alcohol() <= 0 && !this.isPassedOut(drunkState)) {
            this.drunks.remove(playerUuid);
            if (alreadyDrunk) {
                try {
                    this.persistenceHandler.remove(this.drunkStateDataType, playerUuid);
                }
                catch (PersistenceException e) {
                    Logger.logErr(e);
                }
            }
            return null;
        }
        this.drunks.put(playerUuid, drunkState);
        this.planEvent(playerUuid);
        try {
            if (alreadyDrunk) {
                this.persistenceHandler.updateValue(this.drunkStateDataType, new Pair<DrunkStateImpl, UUID>(drunkState, playerUuid));
            } else {
                this.persistenceHandler.insertValue(this.drunkStateDataType, new Pair<DrunkStateImpl, UUID>(drunkState, playerUuid));
            }
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
        return drunkState;
    }

    @Override
    @Nullable
    public DrunkStateImpl getDrunkState(UUID playerUuid) {
        boolean alreadyDrunk = this.drunks.containsKey(playerUuid);
        return alreadyDrunk ? this.drunks.get(playerUuid).recalculate(this.timeSupplier.getAsLong()) : null;
    }

    @Override
    public void reset(Set<BreweryKey> allowedEvents) {
        this.plannedEvents.clear();
        this.drunks.clear();
        this.allowedEvents = allowedEvents;
        this.events.clear();
        this.loadDrunkStates();
        this.drunks.keySet().forEach(this::planEvent);
    }

    @Override
    public void clear(UUID playerUuid) {
        Long plannedEventTime = this.plannedEvents.remove(playerUuid);
        this.drunks.remove(playerUuid);
        try {
            this.persistenceHandler.remove(this.drunkStateDataType, playerUuid);
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
        if (plannedEventTime == null) {
            return;
        }
        if (this.events.containsKey(plannedEventTime)) {
            this.events.get(plannedEventTime).remove(playerUuid);
        }
    }

    public void tick(BiConsumer<UUID, DrunkEvent> action, Predicate<UUID> onlinePredicate) {
        Map<UUID, DrunkEvent> currentEvents = this.events.remove(this.timeSupplier.getAsLong());
        if (currentEvents == null) {
            return;
        }
        HashSet<UUID> toRemove = new HashSet<UUID>();
        for (UUID currentEvent : currentEvents.keySet()) {
            if (this.drunks.containsKey(currentEvent)) continue;
            toRemove.add(currentEvent);
        }
        currentEvents.forEach((key, value) -> this.plannedEvents.remove(key));
        toRemove.forEach(currentEvents::remove);
        currentEvents.forEach(action);
        currentEvents.keySet().stream().filter(onlinePredicate).forEach(this::planEvent);
    }

    @Override
    public void planEvent(UUID playerUuid) {
        if (this.plannedEvents.containsKey(playerUuid)) {
            return;
        }
        DrunkStateImpl drunkState = this.getDrunkState(playerUuid);
        if (drunkState == null) {
            return;
        }
        List<DrunkEvent> drunkEvents = Stream.concat(Registry.DRUNK_EVENT.values().stream(), this.eventRegistry.events().stream()).filter(event -> this.allowedEvents.contains(event.key())).filter(drunkEvent -> drunkEvent.alcoholRequirement() <= drunkState.alcohol()).filter(drunkEvent -> drunkEvent.toxinsRequirement() <= drunkState.toxins()).filter(drunkEvent -> drunkEvent.probabilityWeight() > 0).toList();
        if (drunkEvents.isEmpty()) {
            return;
        }
        int cumulativeSum = RandomUtil.cumulativeSum(drunkEvents);
        DrunkEvent drunkEvent2 = RandomUtil.randomWeighted(drunkEvents);
        double value = 500.0 * (double)(110 - drunkState.alcohol()) / (double)cumulativeSum;
        long time = (long)((double)this.timeSupplier.getAsLong() + Math.max(1.0, RANDOM.nextGaussian(value, value / 2.0)));
        this.events.computeIfAbsent(time, ignored -> new HashMap()).put(playerUuid, drunkEvent2);
        this.plannedEvents.put(playerUuid, time);
    }

    @Override
    public void registerPassedOut(@NotNull UUID playerUUID) {
        this.drunks.computeIfPresent(playerUUID, (ignored, drunkState) -> drunkState.withPassOut(this.timeSupplier.getAsLong()));
    }

    @Override
    public boolean isPassedOut(@NotNull UUID playerUUID) {
        return this.drunks.containsKey(playerUUID) && this.isPassedOut(this.drunks.get(playerUUID));
    }

    private boolean isPassedOut(DrunkStateImpl drunkState) {
        long passOutTimeStamp = drunkState.kickedTimestamp();
        if (passOutTimeStamp == -1L) {
            return false;
        }
        return passOutTimeStamp + (long)Config.config().events().passOutTime() * 1200L > this.timeSupplier.getAsLong();
    }

    @Override
    @Nullable
    public Pair<DrunkEvent, Long> getPlannedEvent(UUID playerUUID) {
        Long time = this.plannedEvents.get(playerUUID);
        if (time == null) {
            return null;
        }
        return new Pair<DrunkEvent, Long>(this.events.get(time).get(playerUUID), time);
    }

    @Generated
    public LongSupplier getTimeSupplier() {
        return this.timeSupplier;
    }
}

