/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import dev.jsinco.brewery.event.DrunkEvent;
import dev.jsinco.brewery.event.EventStep;
import dev.jsinco.brewery.util.BreweryKey;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class CustomEvent {
    private final List<EventStep> steps;
    private final int alcohol;
    private final int toxins;
    private final int probabilityWeight;
    private final String displayName;

    public CustomEvent(List<EventStep> steps, int alcohol, int toxins, int probabilityWeight, @Nullable String displayName) {
        this.steps = steps;
        this.alcohol = alcohol;
        this.toxins = toxins;
        this.probabilityWeight = probabilityWeight;
        this.displayName = displayName;
    }

    public int alcoholRequirement() {
        return this.alcohol;
    }

    public int toxinsRequirement() {
        return this.toxins;
    }

    public String displayName() {
        return this.displayName;
    }

    public int probabilityWeight() {
        return this.probabilityWeight;
    }

    public List<EventStep> getSteps() {
        return List.copyOf(this.steps);
    }

    public static class Builder {
        private final ImmutableList.Builder<EventStep> steps = new ImmutableList.Builder();
        private int alcohol = 0;
        private int toxins = 0;
        private int probabilityWeight = 0;
        private String displayName;

        public Builder addStep(EventStep step) {
            this.steps.add((Object)step);
            return this;
        }

        public Builder alcoholRequirement(int alcoholRequirement) {
            this.alcohol = alcoholRequirement;
            return this;
        }

        public Builder toxinsRequirement(int toxinsRequirement) {
            this.toxins = toxinsRequirement;
            return this;
        }

        public Builder probabilityWeight(int probabilityWeight) {
            this.probabilityWeight = probabilityWeight;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public CustomEvent build() {
            ImmutableList builtSteps = this.steps.build();
            Preconditions.checkArgument((!builtSteps.isEmpty() ? 1 : 0) != 0, (Object)"Steps cannot be empty");
            return new CustomEvent((List<EventStep>)builtSteps, this.alcohol, this.toxins, this.probabilityWeight, this.displayName);
        }

        public Keyed build(BreweryKey key) {
            return new Keyed(this.build(), key);
        }
    }

    public record Keyed(CustomEvent event, BreweryKey key) implements DrunkEvent
    {
        @Override
        public int alcoholRequirement() {
            return this.event.alcoholRequirement();
        }

        @Override
        public int toxinsRequirement() {
            return this.event.toxinsRequirement();
        }

        @Override
        public String displayName() {
            return this.event.displayName();
        }

        @Override
        public int probabilityWeight() {
            return this.event.probabilityWeight();
        }

        public List<EventStep> getSteps() {
            return this.event.getSteps();
        }
    }
}

