/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.event;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.event.EventPropertyExecutable;
import dev.jsinco.brewery.event.EventStepProperty;
import dev.jsinco.brewery.event.NamedDrunkEvent;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class EventStepRegistry {
    private final Map<Class<? extends EventStepProperty>, EventStepFactory<?>> factories = new HashMap();
    private final Map<NamedDrunkEvent, NamedEventStepFactory> namedFactories = new HashMap<NamedDrunkEvent, NamedEventStepFactory>();

    public <T extends EventStepProperty> void register(Class<T> baseClass, EventStepFactory<T> factory) {
        if (this.factories.containsKey(baseClass)) {
            throw new IllegalArgumentException("Factory for " + baseClass.getName() + " is already registered.");
        }
        this.factories.put(baseClass, factory);
    }

    public void register(NamedDrunkEvent key, NamedEventStepFactory factory) {
        if (this.namedFactories.containsKey(key)) {
            throw new IllegalArgumentException("Factory for " + String.valueOf(key) + " is already registered.");
        }
        this.namedFactories.put(key, factory);
    }

    @NotNull
    public <T extends EventStepProperty> EventPropertyExecutable toExecutable(T step) {
        if (step instanceof NamedDrunkEvent) {
            NamedDrunkEvent namedDrunkEvent = (NamedDrunkEvent)step;
            return this.toExecutable(namedDrunkEvent);
        }
        EventStepFactory<?> factory = this.factories.get(step.getClass());
        Preconditions.checkArgument((factory != null ? 1 : 0) != 0, (Object)("No ExecutableEventStep found for EventStep: " + step.getClass().getName()));
        return factory.create(step);
    }

    @NotNull
    public EventPropertyExecutable toExecutable(NamedDrunkEvent step) {
        NamedEventStepFactory factory = this.namedFactories.get(step);
        Preconditions.checkArgument((factory != null ? 1 : 0) != 0, (Object)("No ExecutableEventStep found for EventStep: " + step.getClass().getName()));
        return factory.create();
    }

    @FunctionalInterface
    public static interface EventStepFactory<T extends EventStepProperty> {
        public EventPropertyExecutable create(T var1);
    }

    public static interface NamedEventStepFactory {
        public EventPropertyExecutable create();
    }
}

