/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.math;

import java.util.Random;

public record RangeF(float min, float max) {
    private static final Random RANDOM = new Random();

    public RangeF(float min, float max) {
        if (this.max() < this.min()) {
            throw new IllegalArgumentException("Range max needs to be larger than range min");
        }
        this.min = min;
        this.max = max;
    }

    public Float getRandom() {
        if (this.min() == this.max()) {
            return Float.valueOf(this.max());
        }
        return Float.valueOf(RANDOM.nextFloat(this.min(), this.max()));
    }

    public static RangeF fromString(String str) {
        String[] parts = str.trim().split(";");
        if (parts.length > 2) {
            throw new IllegalArgumentException("Invalid range");
        }
        return new RangeF(Float.parseFloat(parts[0]), parts.length == 2 ? Float.parseFloat(parts[1]) : Float.parseFloat(parts[0]));
    }
}

