/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.recipe;

import dev.jsinco.brewery.brew.BrewQuality;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class QualityData<T> {
    private final Map<BrewQuality, T> backing;

    private QualityData(Map<BrewQuality, T> backing) {
        this.backing = backing;
    }

    public static <T> QualityData<T> equalValued(T t) {
        return new QualityData<Object>(Arrays.stream(BrewQuality.values()).collect(Collectors.toMap(quality -> quality, ignored -> t)));
    }

    public <U> QualityData<U> map(Function<T, U> mapper) {
        HashMap<BrewQuality, U> newBacking = new HashMap<BrewQuality, U>();
        for (Map.Entry<BrewQuality, T> entry : this.backing.entrySet()) {
            newBacking.put(entry.getKey(), mapper.apply(entry.getValue()));
        }
        return new QualityData(newBacking);
    }

    @Nullable
    public T get(BrewQuality brewQuality) {
        return this.backing.get((Object)brewQuality);
    }

    public static <T> QualityData<T> fromValueMapper(Function<BrewQuality, T> mapper) {
        return new QualityData<T>(Arrays.stream(BrewQuality.values()).collect(Collectors.toMap(quality -> quality, mapper)));
    }

    public static QualityData<String> readQualityFactoredString(@Nullable String string) {
        if (string == null) {
            return new QualityData<String>(Map.of());
        }
        if (!string.contains("/")) {
            return new QualityData<String>(Map.of(BrewQuality.BAD, string, BrewQuality.GOOD, string, BrewQuality.EXCELLENT, string));
        }
        String[] list = string.split("/");
        if (list.length != 3) {
            throw new IllegalArgumentException("Expected a string with format <bad>/<good>/<excellent>");
        }
        HashMap<BrewQuality, String> map = new HashMap<BrewQuality, String>();
        for (int i = 0; i < 3; ++i) {
            map.put(BrewQuality.values()[i], list[i]);
        }
        return new QualityData<String>(map);
    }

    public static QualityData<List<String>> readQualityFactoredStringList(@Nullable List<String> stringList) {
        if (stringList == null) {
            return new QualityData<List<String>>(Arrays.stream(BrewQuality.values()).collect(Collectors.toMap(brewQuality -> brewQuality, ignored -> List.of())));
        }
        HashMap<BrewQuality, List> map = new HashMap<BrewQuality, List>();
        for (String string : stringList) {
            if (string.startsWith("+++")) {
                map.computeIfAbsent(BrewQuality.EXCELLENT, ignored -> new ArrayList()).add(string.substring(3));
                continue;
            }
            if (string.startsWith("++")) {
                map.computeIfAbsent(BrewQuality.GOOD, ignored -> new ArrayList()).add(string.substring(2));
                continue;
            }
            if (string.startsWith("+")) {
                map.computeIfAbsent(BrewQuality.BAD, ignored -> new ArrayList()).add(string.substring(1));
                continue;
            }
            for (BrewQuality quality : BrewQuality.values()) {
                map.computeIfAbsent(quality, ignored -> new ArrayList()).add(string);
            }
        }
        for (BrewQuality quality : BrewQuality.values()) {
            map.putIfAbsent(quality, new ArrayList());
        }
        return new QualityData<List<String>>(map);
    }

    public T getOrDefault(BrewQuality quality, T t) {
        return this.backing.getOrDefault((Object)quality, t);
    }
}

