/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.recipes;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.brew.AgeStepImpl;
import dev.jsinco.brewery.brew.BrewingStep;
import dev.jsinco.brewery.brew.CookStepImpl;
import dev.jsinco.brewery.brew.DistillStepImpl;
import dev.jsinco.brewery.brew.MixStepImpl;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.ingredient.Ingredient;
import dev.jsinco.brewery.ingredient.IngredientManager;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.ConfigurationSection;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.file.YamlFile;
import dev.jsinco.brewery.moment.PassedMoment;
import dev.jsinco.brewery.recipes.RecipeImpl;
import dev.jsinco.brewery.recipes.RecipeResultReader;
import dev.jsinco.brewery.util.BreweryKey;
import dev.jsinco.brewery.util.FutureUtil;
import dev.jsinco.brewery.util.Logger;
import dev.jsinco.brewery.util.Registry;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jetbrains.annotations.NotNull;

public class RecipeReader<I> {
    private final File folder;
    private final RecipeResultReader<I> recipeResultReader;
    private final IngredientManager<I> ingredientManager;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public RecipeReader(File folder, RecipeResultReader<I> recipeResultReader, IngredientManager<I> ingredientManager) {
        this.folder = folder;
        this.recipeResultReader = recipeResultReader;
        this.ingredientManager = ingredientManager;
    }

    public List<CompletableFuture<RecipeImpl<I>>> readRecipes() {
        Path mainDir = this.folder.toPath();
        YamlFile recipesFile = new YamlFile(mainDir.resolve("recipes.yml").toFile());
        try {
            recipesFile.createOrLoadWithComments();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ConfigurationSection recipesSection = recipesFile.getConfigurationSection("recipes");
        return recipesSection.getKeys(false).stream().map(key -> this.getRecipe(recipesSection.getConfigurationSection((String)key), (String)key).handleAsync((recipe, exception) -> {
            if (exception != null) {
                Logger.logErr("Exception when reading recipe: " + key);
                Logger.logErr(exception);
                return null;
            }
            return recipe;
        }, (Executor)this.executor)).toList();
    }

    private CompletableFuture<RecipeImpl<I>> getRecipe(ConfigurationSection recipe, String recipeName) {
        try {
            return this.parseSteps(recipe.getMapList("steps")).thenApplyAsync(steps -> new RecipeImpl.Builder(recipeName).brewDifficulty(recipe.getDouble("brew-difficulty", 1.0)).recipeResults(this.recipeResultReader.readRecipeResults(recipe)).steps((List<BrewingStep>)steps).build());
        }
        catch (Throwable e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @NotNull
    private CompletableFuture<List<BrewingStep>> parseSteps(List<Map<?, ?>> steps) {
        return FutureUtil.mergeFutures(steps.stream().map(this::parseStep).toList());
    }

    private CompletableFuture<BrewingStep> parseStep(Map<?, ?> map) {
        BrewingStep.StepType type = BrewingStep.StepType.valueOf(String.valueOf(map.get("type")).toUpperCase(Locale.ROOT));
        this.checkStep(type, map);
        return switch (type) {
            default -> throw new MatchException(null, null);
            case BrewingStep.StepType.COOK -> this.ingredientManager.getIngredientsWithAmount((List)map.get("ingredients")).thenApplyAsync(ingredients -> new CookStepImpl(new PassedMoment((long)(((Number)map.get("cook-time")).doubleValue() * (double)Config.config().cauldrons().cookingMinuteTicks())), (Map<? extends Ingredient, Integer>)ingredients, Registry.CAULDRON_TYPE.get(BreweryKey.parse(map.containsKey("cauldron-type") ? map.get("cauldron-type").toString().toLowerCase(Locale.ROOT) : "water"))));
            case BrewingStep.StepType.DISTILL -> CompletableFuture.completedFuture(new DistillStepImpl((Integer)map.get("runs")));
            case BrewingStep.StepType.AGE -> CompletableFuture.completedFuture(new AgeStepImpl(new PassedMoment((long)(((Number)map.get("age-years")).doubleValue() * (double)Config.config().barrels().agingYearTicks())), Registry.BARREL_TYPE.get(BreweryKey.parse(map.get("barrel-type").toString().toLowerCase(Locale.ROOT)))));
            case BrewingStep.StepType.MIX -> this.ingredientManager.getIngredientsWithAmount((List)map.get("ingredients")).thenApplyAsync(ingredients -> new MixStepImpl(new PassedMoment((long)(((Number)map.get("mix-time")).doubleValue() * (double)Config.config().cauldrons().cookingMinuteTicks())), (Map<? extends Ingredient, Integer>)ingredients));
        };
    }

    private void checkStep(BrewingStep.StepType type, Map<?, ?> map) throws IllegalArgumentException {
        switch (type) {
            case COOK: {
                Number doubleValue;
                Object obj = map.get("cook-time");
                Preconditions.checkArgument((obj instanceof Number && (doubleValue = (Number)obj).doubleValue() > 0.0 ? 1 : 0) != 0, (Object)"Expected positive number value for 'cook-time' in cook step!");
                Preconditions.checkArgument((boolean)(map.get("ingredients") instanceof List), (Object)"Expected string list value for 'ingredients' in cook step!");
                Preconditions.checkArgument((!map.containsKey("cauldron-type") || map.get("cauldron-type") instanceof String ? 1 : 0) != 0, (Object)"Expected string value for 'cauldron-type' in cook step!");
                String cauldronType = map.containsKey("cauldron-type") ? (String)map.get("cauldron-type") : "water";
                Preconditions.checkArgument((boolean)Registry.CAULDRON_TYPE.containsKey(BreweryKey.parse(cauldronType)), (Object)"Expected a valid cauldron type for 'cauldron-type' in cook step!");
                break;
            }
            case DISTILL: {
                Preconditions.checkArgument((boolean)(map.get("runs") instanceof Integer), (Object)"Expected integer value for 'runs' in distill step!");
                break;
            }
            case AGE: {
                Number doubleValue;
                Object obj = map.get("age-years");
                Preconditions.checkArgument((obj instanceof Number && (doubleValue = (Number)obj).doubleValue() > 0.5 ? 1 : 0) != 0, (Object)"Expected number larger than 0.5 for 'age-years' in age step!");
                Preconditions.checkArgument((!map.containsKey("barrel-type") || map.get("barrel-type") instanceof String ? 1 : 0) != 0, (Object)"Expected string value for 'barrel-type' in age step!");
                String barrelType = map.containsKey("barrel-type") ? (String)map.get("barrel-type") : "any";
                Preconditions.checkArgument((boolean)Registry.BARREL_TYPE.containsKey(BreweryKey.parse(barrelType)), (Object)"Expected a valid barrel type for 'barrel-type' in age step!");
                break;
            }
            case MIX: {
                Number doubleValue;
                Object obj = map.get("mix-time");
                Preconditions.checkArgument((obj instanceof Number && (doubleValue = (Number)obj).doubleValue() > 0.0 ? 1 : 0) != 0, (Object)"Expected positive number value for 'mix-time' in mix step!");
                Preconditions.checkArgument((boolean)(map.get("ingredients") instanceof List), (Object)"Expected string list value for 'ingredients' in mix step!");
            }
        }
    }

    public static int parseAlcoholString(String str) {
        return Integer.parseInt(str.replace("%", "").replace(" ", ""));
    }
}

