/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.recipes;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.brew.BrewingStep;
import dev.jsinco.brewery.ingredient.Ingredient;
import dev.jsinco.brewery.recipe.Recipe;
import dev.jsinco.brewery.recipe.RecipeRegistry;
import dev.jsinco.brewery.recipe.RecipeResult;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class RecipeRegistryImpl<I>
implements RecipeRegistry<I> {
    private Map<String, Recipe<I>> recipes = new ConcurrentHashMap<String, Recipe<I>>();
    private Map<String, RecipeResult<I>> defaultRecipes = new HashMap<String, RecipeResult<I>>();
    private List<RecipeResult<I>> defaultRecipeList = new ArrayList<RecipeResult<I>>();
    private Set<Ingredient> allIngredients = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Random RANDOM = new Random();

    public void registerRecipes(@NotNull Map<String, Recipe<I>> recipes) {
        this.recipes = new HashMap<String, Recipe<I>>(recipes);
        recipes.values().stream().map(this::getRecipeIngredients).flatMap(Collection::stream).forEach(this.allIngredients::add);
    }

    @Override
    public Optional<Recipe<I>> getRecipe(@NotNull String recipeName) {
        Preconditions.checkNotNull((Object)recipeName);
        return Optional.ofNullable(this.recipes.get(recipeName));
    }

    @Override
    public Collection<Recipe<I>> getRecipes() {
        return this.recipes.values();
    }

    @Override
    public void registerRecipe(Recipe<I> recipe) {
        this.recipes.put(recipe.getRecipeName(), recipe);
        this.allIngredients.addAll(this.getRecipeIngredients(recipe));
    }

    @Override
    public void unRegisterRecipe(Recipe<I> recipe) {
        this.recipes.remove(recipe.getRecipeName());
        this.allIngredients = this.recipes.values().stream().map(this::getRecipeIngredients).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Optional<RecipeResult<I>> getDefaultRecipe(@NotNull String recipeName) {
        Preconditions.checkNotNull((Object)recipeName);
        return Optional.ofNullable(this.defaultRecipes.get(recipeName));
    }

    private List<Ingredient> getRecipeIngredients(Recipe<?> recipe) {
        return recipe.getSteps().stream().filter(BrewingStep.IngredientsStep.class::isInstance).map(BrewingStep.IngredientsStep.class::cast).map(BrewingStep.IngredientsStep::ingredients).map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public Collection<RecipeResult<I>> getDefaultRecipes() {
        return this.defaultRecipeList;
    }

    @Override
    public void registerDefaultRecipe(String name, RecipeResult<I> recipe) {
        this.defaultRecipes.put(name, recipe);
        this.defaultRecipeList.add(recipe);
    }

    @Override
    public void unRegisterDefaultRecipe(String name) {
        RecipeResult<I> defaultRecipe = this.defaultRecipes.remove(name);
        if (defaultRecipe == null) {
            return;
        }
        this.defaultRecipeList.remove(defaultRecipe);
    }

    public RecipeResult<I> getRandomDefaultRecipe() {
        return this.defaultRecipeList.get(RANDOM.nextInt(this.defaultRecipeList.size()));
    }

    public void registerDefaultRecipes(@NotNull Map<String, RecipeResult<I>> defaultRecipes) {
        this.defaultRecipes = (Map)Preconditions.checkNotNull(defaultRecipes);
        this.defaultRecipeList = List.copyOf(defaultRecipes.values());
    }

    @Override
    public boolean isRegisteredIngredient(Ingredient ingredient) {
        return this.allIngredients.stream().anyMatch((Predicate<Ingredient>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ldev/jsinco/brewery/ingredient/Ingredient;)Z)((Ingredient)ingredient));
    }

    @Override
    public Set<Ingredient> registeredIngredients() {
        return this.allIngredients;
    }
}

