/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.structure;

import com.google.gson.JsonElement;
import dev.jsinco.brewery.structure.StructureType;
import dev.jsinco.brewery.util.BreweryKey;
import dev.jsinco.brewery.util.BreweryKeyed;
import dev.jsinco.brewery.util.Registry;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;

public record StructureMeta<V>(BreweryKey key, Predicate<Object> validator, Function<JsonElement, V> deserializer, V defaultValue) implements BreweryKeyed
{
    public static final StructureMeta<Boolean> USE_BARREL_SUBSTITUTION = new StructureMeta<Boolean>(BreweryKey.parse("use_barrel_substitution"), Boolean.class::isInstance, JsonElement::getAsBoolean, false);
    public static final StructureMeta<Integer> INVENTORY_SIZE = new StructureMeta<Integer>(BreweryKey.parse("inventory_size"), value -> {
        Integer integer;
        return value instanceof Integer && (integer = (Integer)value) % 9 == 0 && integer > 0;
    }, JsonElement::getAsInt, 9);
    public static final StructureMeta<String> TAGGED_MATERIAL = new StructureMeta<String>(BreweryKey.parse("tagged_material"), String.class::isInstance, JsonElement::getAsString, "decorated_pot");
    public static final StructureMeta<Long> PROCESS_TIME = new StructureMeta<Long>(BreweryKey.parse("process_time"), Long.class::isInstance, JsonElement::getAsLong, 80L);
    public static final StructureMeta<Integer> PROCESS_AMOUNT = new StructureMeta<Integer>(BreweryKey.parse("process_amount"), Integer.class::isInstance, JsonElement::getAsInt, 1);
    public static final StructureMeta<StructureType> TYPE = new StructureMeta<StructureType>(BreweryKey.parse("type"), StructureType.class::isInstance, jsonElement -> Registry.STRUCTURE_TYPE.get(BreweryKey.parse(jsonElement.getAsString().toLowerCase(Locale.ROOT))), StructureType.BARREL);

    @Override
    public String toString() {
        return "StructureMeta(" + String.valueOf(this.key) + ")";
    }
}

