/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.util;

import dev.jsinco.brewery.brew.Brew;
import dev.jsinco.brewery.brew.BrewQuality;
import dev.jsinco.brewery.brew.BrewScore;
import dev.jsinco.brewery.brew.BrewingStep;
import dev.jsinco.brewery.brew.PartialBrewScore;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.configuration.locale.TranslationsConfig;
import dev.jsinco.brewery.effect.DrunkState;
import dev.jsinco.brewery.ingredient.Ingredient;
import dev.jsinco.brewery.recipe.RecipeRegistry;
import dev.jsinco.brewery.recipes.BrewScoreImpl;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageUtil {
    private static final char SKULL = '\u2620';

    public static Component miniMessage(String msg, TagResolver ... resolvers) {
        return MiniMessage.miniMessage().deserialize(msg, resolvers);
    }

    public static void message(Audience audience, String msg, TagResolver ... resolvers) {
        audience.sendMessage(MessageUtil.miniMessage(msg, resolvers));
    }

    public static TagResolver getScoreTagResolver(@NotNull BrewScore score) {
        BrewQuality quality = score.brewQuality();
        return TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.component((String)"quality", (ComponentLike)Component.text((String)score.displayName())), Placeholder.styling((String)"quality_color", (StyleBuilderApplicable[])MessageUtil.resolveQualityColor(quality))});
    }

    @NotNull
    public static TagResolver getBrewStepTagResolver(BrewingStep brewingStep, List<PartialBrewScore> scores, double difficulty) {
        BrewingStep brewingStep2 = brewingStep;
        Objects.requireNonNull(brewingStep2);
        BrewingStep brewingStep3 = brewingStep2;
        int n = 0;
        TagResolver resolver = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BrewingStep.Age.class, BrewingStep.Cook.class, BrewingStep.Distill.class, BrewingStep.Mix.class}, (Object)brewingStep3, n)) {
            case 0 -> {
                BrewingStep.Age age = (BrewingStep.Age)brewingStep3;
                yield TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.parsed((String)"barrel_type", (String)TranslationsConfig.BARREL_TYPE.get(age.barrelType().name().toLowerCase(Locale.ROOT))), Formatter.number((String)"aging_years", (Number)(age.time().moment() / Config.config().barrels().agingYearTicks()))});
            }
            case 1 -> {
                BrewingStep.Cook cook = (BrewingStep.Cook)brewingStep3;
                yield TagResolver.resolver((TagResolver[])new TagResolver[]{Formatter.number((String)"cooking_time", (Number)(cook.time().moment() / Config.config().cauldrons().cookingMinuteTicks())), Placeholder.component((String)"ingredients", (ComponentLike)((ComponentLike)cook.ingredients().entrySet().stream().map(entry -> ((Ingredient)entry.getKey()).displayName().append((Component)Component.text((String)("/" + String.valueOf(entry.getValue()))))).collect(Component.toComponent((Component)Component.text((String)", "))))), Placeholder.parsed((String)"cauldron_type", (String)TranslationsConfig.CAULDRON_TYPE.get(cook.cauldronType().name().toLowerCase(Locale.ROOT)))});
            }
            case 2 -> {
                BrewingStep.Distill distill = (BrewingStep.Distill)brewingStep3;
                yield Formatter.number((String)"distill_runs", (Number)distill.runs());
            }
            case 3 -> {
                BrewingStep.Mix mix = (BrewingStep.Mix)brewingStep3;
                yield TagResolver.resolver((TagResolver[])new TagResolver[]{Formatter.number((String)"mixing_time", (Number)(mix.time().moment() / Config.config().cauldrons().cookingMinuteTicks())), Placeholder.component((String)"ingredients", (ComponentLike)((ComponentLike)mix.ingredients().entrySet().stream().map(entry -> ((Ingredient)entry.getKey()).displayName().append((Component)Component.text((String)("/" + String.valueOf(entry.getValue()))))).collect(Component.toComponent((Component)Component.text((String)", ")))))});
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(brewingStep));
        };
        return TagResolver.resolver((TagResolver[])new TagResolver[]{resolver, TagResolver.resolver((TagResolver[])((TagResolver[])scores.stream().map(partialBrewScore -> Placeholder.styling((String)partialBrewScore.type().colorKey(), (StyleBuilderApplicable[])MessageUtil.resolveQualityColor(BrewScoreImpl.quality(BrewScoreImpl.applyDifficulty(partialBrewScore.score(), difficulty))))).toArray(TagResolver[]::new)))});
    }

    @NotNull
    public static StyleBuilderApplicable[] resolveQualityColor(@Nullable BrewQuality quality) {
        StyleBuilderApplicable[] styleBuilderApplicableArray;
        if (quality != null) {
            StyleBuilderApplicable[] styleBuilderApplicableArray2 = new StyleBuilderApplicable[1];
            styleBuilderApplicableArray = styleBuilderApplicableArray2;
            styleBuilderApplicableArray2[0] = TextColor.color((int)quality.getColor());
        } else {
            StyleBuilderApplicable[] styleBuilderApplicableArray3 = new StyleBuilderApplicable[2];
            styleBuilderApplicableArray3[0] = NamedTextColor.GRAY;
            styleBuilderApplicableArray = styleBuilderApplicableArray3;
            styleBuilderApplicableArray3[1] = TextDecoration.STRIKETHROUGH;
        }
        return styleBuilderApplicableArray;
    }

    @NotNull
    public static Stream<Component> compileBrewInfo(Brew brew, BrewScore score, boolean detailed) {
        List<BrewingStep> brewingSteps = brew.getCompletedSteps();
        Stream.Builder<Component> streamBuilder = Stream.builder();
        for (int i = 0; i < brewingSteps.size(); ++i) {
            BrewingStep brewingStep = brewingSteps.get(i);
            String line = (detailed ? TranslationsConfig.DETAILED_BREW_TOOLTIP : TranslationsConfig.BREW_TOOLTIP_BREWING).get(brewingStep.stepType().name().toLowerCase(Locale.ROOT));
            streamBuilder.add(MessageUtil.miniMessage(line, MessageUtil.getBrewStepTagResolver(brewingStep, score.getPartialScores(i), score.brewDifficulty())));
        }
        return streamBuilder.build();
    }

    @NotNull
    public static Stream<Component> compileBrewInfo(Brew brew, boolean detailed, RecipeRegistry<?> registry) {
        BrewScore score = brew.closestRecipe(registry).map(brew::score).orElse(BrewScoreImpl.failed(brew));
        return MessageUtil.compileBrewInfo(brew, score, detailed);
    }

    @NotNull
    public static TagResolver getDrunkStateTagResolver(@Nullable DrunkState drunkState) {
        return TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.component((String)"alcohol_level", (ComponentLike)MessageUtil.compileAlcoholLevel(drunkState == null ? 0 : drunkState.alcohol())), Placeholder.component((String)"toxins_level", (ComponentLike)MessageUtil.compileToxinsLevel(drunkState == null ? 0 : drunkState.toxins()))});
    }

    @NotNull
    private static ComponentLike compileToxinsLevel(int level) {
        int partition = level / 20;
        StringBuilder skulls = new StringBuilder();
        skulls.repeat(9760, partition);
        skulls.repeat("  ", 5 - partition);
        return Component.text((String)skulls.toString()).color((TextColor)NamedTextColor.GREEN);
    }

    @NotNull
    private static ComponentLike compileAlcoholLevel(int level) {
        int partitionedLevel = level / 5;
        StringBuilder okLevel = new StringBuilder();
        okLevel.repeat("|", Math.min(partitionedLevel, 4));
        StringBuilder warningLevel = new StringBuilder();
        warningLevel.repeat("|", Math.max(Math.min(partitionedLevel, 16) - 4, 0));
        StringBuilder severeLevel = new StringBuilder();
        severeLevel.repeat("|", Math.max(partitionedLevel - 16, 0));
        StringBuilder remainder = new StringBuilder();
        remainder.repeat("|", 20 - partitionedLevel);
        return ((TextComponent)((TextComponent)((TextComponent)Component.text((String)okLevel.toString()).color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)warningLevel.toString()).color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)severeLevel.toString()).color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)remainder.toString()).color((TextColor)NamedTextColor.BLACK));
    }

    @NotNull
    public static TagResolver getTimeTagResolver(long timeTicks) {
        long cookingMinuteTicks = Config.config().cauldrons().cookingMinuteTicks();
        long seconds = timeTicks % cookingMinuteTicks * 60L / cookingMinuteTicks;
        long minutes = timeTicks / cookingMinuteTicks;
        return Placeholder.parsed((String)"time", (String)String.format("%d:%02d", minutes, seconds));
    }
}

