/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.brew.PartialBrewScore;
import dev.jsinco.brewery.api.brew.ScoreType;
import dev.jsinco.brewery.brew.BrewingStepUtil;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record DistillStepImpl(int runs) implements BrewingStep.Distill
{
    private static final Map<ScoreType, PartialBrewScore> BREW_STEP_MISMATCH = Stream.of(new PartialBrewScore(0.0, ScoreType.DISTILL_AMOUNT)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));

    @Override
    public DistillStepImpl incrementRuns() {
        return new DistillStepImpl(this.runs + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<ScoreType, PartialBrewScore> proximityScores(BrewingStep other) {
        int otherRuns;
        if (!(other instanceof DistillStepImpl)) return BREW_STEP_MISMATCH;
        DistillStepImpl distillStepImpl = (DistillStepImpl)other;
        try {
            int n;
            otherRuns = n = distillStepImpl.runs();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        double distillScore = Math.sqrt(BrewingStepUtil.nearbyValueScore(this.runs, otherRuns));
        return Stream.of(new PartialBrewScore(distillScore, ScoreType.DISTILL_AMOUNT)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));
    }

    @Override
    public BrewingStep.StepType stepType() {
        return BrewingStep.StepType.DISTILL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<ScoreType, PartialBrewScore> maximumScores(BrewingStep other) {
        int runs1;
        if (!(other instanceof DistillStepImpl)) return BREW_STEP_MISMATCH;
        DistillStepImpl distillStepImpl = (DistillStepImpl)other;
        try {
            int n;
            runs1 = n = distillStepImpl.runs();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        double maximumDistillScore = runs1 < this.runs ? 1.0 : BrewingStepUtil.nearbyValueScore(this.runs, runs1);
        return Stream.of(new PartialBrewScore(maximumDistillScore, ScoreType.DISTILL_AMOUNT)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));
    }

    @Override
    public Map<ScoreType, PartialBrewScore> failedScores() {
        return BREW_STEP_MISMATCH;
    }
}

