/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.brew.BrewManager;
import dev.jsinco.brewery.api.breweries.BarrelType;
import dev.jsinco.brewery.api.breweries.Distillery;
import dev.jsinco.brewery.api.breweries.InventoryAccessible;
import dev.jsinco.brewery.api.breweries.Tickable;
import dev.jsinco.brewery.api.effect.modifier.ModifierManager;
import dev.jsinco.brewery.api.event.CustomEventRegistry;
import dev.jsinco.brewery.api.event.EventStepRegistry;
import dev.jsinco.brewery.api.recipe.DefaultRecipe;
import dev.jsinco.brewery.api.recipe.Recipe;
import dev.jsinco.brewery.api.structure.MultiblockStructure;
import dev.jsinco.brewery.api.structure.StructureMeta;
import dev.jsinco.brewery.api.structure.StructureType;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.bukkit.api.TheBrewingProjectApi;
import dev.jsinco.brewery.bukkit.api.event.TBPReloadEvent;
import dev.jsinco.brewery.bukkit.brew.BukkitBrewManager;
import dev.jsinco.brewery.bukkit.breweries.BreweryRegistry;
import dev.jsinco.brewery.bukkit.command.BreweryCommand;
import dev.jsinco.brewery.bukkit.configuration.serializer.BreweryLocationSerializer;
import dev.jsinco.brewery.bukkit.configuration.serializer.MaterialSerializer;
import dev.jsinco.brewery.bukkit.effect.SqlDrunkStateDataType;
import dev.jsinco.brewery.bukkit.effect.SqlDrunkenModifierDataType;
import dev.jsinco.brewery.bukkit.effect.event.ActiveEventsRegistry;
import dev.jsinco.brewery.bukkit.effect.event.DrunkEventExecutor;
import dev.jsinco.brewery.bukkit.event.BlockEventListener;
import dev.jsinco.brewery.bukkit.event.BrewMigrationListener;
import dev.jsinco.brewery.bukkit.event.EntityEventListener;
import dev.jsinco.brewery.bukkit.event.InventoryEventListener;
import dev.jsinco.brewery.bukkit.event.LegacyPlayerJoinListener;
import dev.jsinco.brewery.bukkit.event.PlayerEventListener;
import dev.jsinco.brewery.bukkit.event.PlayerJoinListener;
import dev.jsinco.brewery.bukkit.event.PlayerWalkListener;
import dev.jsinco.brewery.bukkit.event.WorldEventListener;
import dev.jsinco.brewery.bukkit.ingredient.BukkitIngredientManager;
import dev.jsinco.brewery.bukkit.integration.IntegrationManagerImpl;
import dev.jsinco.brewery.bukkit.migration.Migrations;
import dev.jsinco.brewery.bukkit.recipe.BukkitRecipeResultReader;
import dev.jsinco.brewery.bukkit.recipe.DefaultRecipeReader;
import dev.jsinco.brewery.bukkit.structure.BarrelBlockDataMatcher;
import dev.jsinco.brewery.bukkit.structure.BreweryStructure;
import dev.jsinco.brewery.bukkit.structure.GenericBlockDataMatcher;
import dev.jsinco.brewery.bukkit.structure.StructureJsonFormatValidator;
import dev.jsinco.brewery.bukkit.structure.StructureReadException;
import dev.jsinco.brewery.bukkit.structure.StructureReader;
import dev.jsinco.brewery.bukkit.structure.StructureRegistry;
import dev.jsinco.brewery.bukkit.util.BreweryTimeDataType;
import dev.jsinco.brewery.bukkit.util.BukkitIngredientUtil;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.configuration.DrunkenModifierSection;
import dev.jsinco.brewery.configuration.EventSection;
import dev.jsinco.brewery.configuration.IngredientsSection;
import dev.jsinco.brewery.configuration.OkaeriSerdesPackBuilder;
import dev.jsinco.brewery.configuration.locale.BreweryTranslator;
import dev.jsinco.brewery.configuration.serializers.ComponentSerializer;
import dev.jsinco.brewery.configuration.serializers.ConditionSerializer;
import dev.jsinco.brewery.configuration.serializers.ConsumableSerializer;
import dev.jsinco.brewery.configuration.serializers.CustomEventSerializer;
import dev.jsinco.brewery.configuration.serializers.DrunkenModifierSerializer;
import dev.jsinco.brewery.configuration.serializers.EventProbabilitySerializer;
import dev.jsinco.brewery.configuration.serializers.EventRegistrySerializer;
import dev.jsinco.brewery.configuration.serializers.EventStepSerializer;
import dev.jsinco.brewery.configuration.serializers.IntervalSerializer;
import dev.jsinco.brewery.configuration.serializers.LocaleSerializer;
import dev.jsinco.brewery.configuration.serializers.MinutesDurationSerializer;
import dev.jsinco.brewery.configuration.serializers.ModifierDisplaySerializer;
import dev.jsinco.brewery.configuration.serializers.ModifierExpressionSerializer;
import dev.jsinco.brewery.configuration.serializers.ModifierTooltipSerializer;
import dev.jsinco.brewery.configuration.serializers.NamedDrunkEventSerializer;
import dev.jsinco.brewery.configuration.serializers.RangeDSerializer;
import dev.jsinco.brewery.configuration.serializers.SecretKeySerializer;
import dev.jsinco.brewery.configuration.serializers.SoundDefinitionSerializer;
import dev.jsinco.brewery.configuration.serializers.TicksDurationSerializer;
import dev.jsinco.brewery.database.PersistenceException;
import dev.jsinco.brewery.database.sql.Database;
import dev.jsinco.brewery.database.sql.DatabaseDriver;
import dev.jsinco.brewery.effect.DrunksManagerImpl;
import dev.jsinco.brewery.effect.ModifierManagerImpl;
import dev.jsinco.brewery.effect.text.DrunkTextRegistry;
import dev.jsinco.brewery.format.TimeFormatRegistry;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.OkaeriSerdesPack;
import dev.jsinco.brewery.recipes.RecipeReader;
import dev.jsinco.brewery.recipes.RecipeRegistryImpl;
import dev.jsinco.brewery.structure.PlacedStructureRegistryImpl;
import dev.jsinco.brewery.util.ClassUtil;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.Translator;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class TheBrewingProject
extends JavaPlugin
implements TheBrewingProjectApi {
    private static TheBrewingProject instance;
    private StructureRegistry structureRegistry;
    private PlacedStructureRegistryImpl placedStructureRegistry;
    private RecipeRegistryImpl<ItemStack> recipeRegistry;
    private BreweryRegistry breweryRegistry;
    private Database database;
    private DrunkTextRegistry drunkTextRegistry;
    private TimeFormatRegistry timeFormatRegistry;
    private DrunksManagerImpl<Connection> drunksManager;
    private CustomEventRegistry customDrunkEventRegistry;
    private WorldEventListener worldEventListener;
    private EventStepRegistry eventStepRegistry;
    private DrunkEventExecutor drunkEventExecutor;
    private long time;
    private BrewManager<ItemStack> brewManager = new BukkitBrewManager();
    private final IntegrationManagerImpl integrationManager = new IntegrationManagerImpl();
    private final ActiveEventsRegistry activeEventsRegistry = new ActiveEventsRegistry();
    private PlayerWalkListener playerWalkListener;
    private ModifierManager modifierManager = new ModifierManagerImpl();
    private BreweryTranslator translator;
    private boolean successfullLoad = false;

    public void initialize() {
        instance = this;
        EventSection.migrateEvents(this.getDataFolder());
        Config.load(this.getDataFolder(), this.serializers());
        DrunkenModifierSection.load(this.getDataFolder(), this.serializers());
        EventSection.load(this.getDataFolder(), this.serializers());
        DrunkenModifierSection.validate();
        EventSection.validate();
        IngredientsSection.load(this.getDataFolder(), this.serializers());
        IngredientsSection.validate(BukkitIngredientManager.INSTANCE, BukkitIngredientUtil::tagValuesFromString);
        this.translator = new BreweryTranslator(new File(this.getDataFolder(), "locale"));
        this.translator.reload();
        GlobalTranslator.translator().addSource((Translator)this.translator);
        this.structureRegistry = new StructureRegistry();
        this.placedStructureRegistry = new PlacedStructureRegistryImpl();
        this.breweryRegistry = new BreweryRegistry();
        this.recipeRegistry = new RecipeRegistryImpl();
        this.drunkTextRegistry = new DrunkTextRegistry();
        this.timeFormatRegistry = new TimeFormatRegistry();
        this.customDrunkEventRegistry = EventSection.events().customEvents();
        this.eventStepRegistry = new EventStepRegistry();
        this.drunkEventExecutor = new DrunkEventExecutor();
    }

    public void onLoad() {
        this.saveResources();
        Migrations.migrateAllConfigFiles(this.getDataFolder());
        this.initialize();
        Bukkit.getServicesManager().register(TheBrewingProjectApi.class, (Object)this, (Plugin)this, ServicePriority.Normal);
        this.integrationManager.registerIntegrations();
        this.integrationManager.loadIntegrations();
        this.successfullLoad = true;
    }

    private OkaeriSerdesPack serializers() {
        return new OkaeriSerdesPackBuilder().add(new BreweryLocationSerializer()).add(new EventRegistrySerializer()).add(new EventStepSerializer()).add(new CustomEventSerializer()).add(new SoundDefinitionSerializer()).add(new IntervalSerializer()).add(new MaterialSerializer()).add(new LocaleSerializer()).add(new ConsumableSerializer()).add(new NamedDrunkEventSerializer()).add(new DrunkenModifierSerializer()).add(new ModifierExpressionSerializer()).add(new ModifierDisplaySerializer()).add(new ComponentSerializer()).add(new ModifierTooltipSerializer()).add(new EventProbabilitySerializer()).add(new RangeDSerializer()).add(new ConditionSerializer()).add(new SecretKeySerializer()).add(new MinutesDurationSerializer()).add(new TicksDurationSerializer()).build();
    }

    public void reload() {
        Migrations.migrateAllConfigFiles(this.getDataFolder());
        this.saveResources();
        this.closeDatabase();
        Config.config().load(true);
        DrunkenModifierSection.modifiers().load(true);
        EventSection.events().load(true);
        DrunkenModifierSection.validate();
        EventSection.validate();
        IngredientsSection.ingredients().load(true);
        IngredientsSection.validate(BukkitIngredientManager.INSTANCE, BukkitIngredientUtil::tagValuesFromString);
        this.translator.reload();
        this.structureRegistry.clear();
        this.placedStructureRegistry.clear();
        this.breweryRegistry.clear();
        this.loadStructures();
        this.drunkTextRegistry.clear();
        this.customDrunkEventRegistry.clear();
        EventSection.events().customEvents().events().forEach(this.customDrunkEventRegistry::registerCustomEvent);
        this.drunkEventExecutor.clear();
        this.customDrunkEventRegistry = EventSection.events().customEvents();
        this.saveResources();
        this.database = new Database(DatabaseDriver.SQLITE);
        try {
            this.database.init(this.getDataFolder());
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
        this.drunksManager.reset(EventSection.events().enabledRandomEvents().stream().map(BreweryKey::parse).collect(Collectors.toSet()));
        this.worldEventListener.init();
        this.recipeRegistry.clear();
        RecipeReader<ItemStack> recipeReader = new RecipeReader<ItemStack>(this.getDataFolder(), new BukkitRecipeResultReader(), BukkitIngredientManager.INSTANCE);
        recipeReader.readRecipes().forEach(recipeFuture -> recipeFuture.thenAcceptAsync(recipe -> this.recipeRegistry.registerRecipe((Recipe<ItemStack>)recipe)));
        DefaultRecipeReader.readDefaultRecipes(this.getDataFolder()).forEach((string, defaultRecipe) -> defaultRecipe.whenComplete((defaultRecipe1, throwable) -> {
            if (throwable != null) {
                Logger.logErr("Could not read default recipe: " + string);
                Logger.logErr(throwable);
                return;
            }
            this.recipeRegistry.registerDefaultRecipe((String)string, (DefaultRecipe<ItemStack>)defaultRecipe1);
        }));
        this.loadDrunkenReplacements();
        this.loadTimeFormats();
        new TBPReloadEvent().callEvent();
    }

    private void loadDrunkenReplacements() {
        File file = new File(this.getDataFolder(), "/locale/" + Config.config().language().toLanguageTag() + ".drunk_text.json");
        if (!file.exists()) {
            Logger.log("Could not find drunken text replacements for your language, using en-US");
            file = new File(this.getDataFolder(), "/locale/en-US.drunk_text.json");
        }
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.drunkTextRegistry.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadTimeFormats() {
        String fileName = Config.config().language().toLanguageTag() + ".time.properties";
        File file = new File(this.getDataFolder(), "/locale/" + fileName);
        if (!file.exists() && TimeFormatRegistry.class.getResource("/locale/" + fileName) == null) {
            Logger.log("Could not find time formats for your language, using en-US");
            file = new File(this.getDataFolder(), "/locale/en-US.time.properties");
        }
        try {
            this.timeFormatRegistry.sync(file);
            this.timeFormatRegistry.load(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadStructures() {
        File structureRoot = new File(this.getDataFolder(), "structures");
        if (!structureRoot.exists() && !structureRoot.mkdirs()) {
            throw new RuntimeException("Could not create structure root: " + String.valueOf(structureRoot));
        }
        Stream.of("small_barrel", "large_barrel", "bamboo_distillery").map(string -> "structures/" + string).flatMap(name -> Stream.of(name + ".schem", name + ".json")).forEach(this::saveResourceIfNotExists);
        Stream.of(structureRoot.listFiles()).filter(file -> file.getName().endsWith(".json")).map(File::toPath).filter(StructureJsonFormatValidator::validate).flatMap(path -> {
            try {
                return Stream.of(StructureReader.fromJson(path));
            }
            catch (StructureReadException | IOException e) {
                Logger.logErr("Could not load structure: " + String.valueOf(path));
                Logger.logErr(e);
                return Stream.empty();
            }
        }).forEach(structure -> {
            if (structure.getMetaOrDefault(StructureMeta.USE_BARREL_SUBSTITUTION, false).booleanValue()) {
                this.structureRegistry.addStructure((BreweryStructure)structure, BarrelBlockDataMatcher.INSTANCE, (T[])BarrelType.PLACEABLE_TYPES);
            } else {
                this.structureRegistry.addStructure((BreweryStructure)structure, new GenericBlockDataMatcher(structure.getMetaOrDefault(StructureMeta.BLOCK_REPLACEMENTS, List.of())), (T[])new Void[1]);
            }
        });
    }

    public void onEnable() {
        Preconditions.checkState((boolean)this.successfullLoad, (Object)"Plugin loading failed, see above exception in load stage");
        this.loadStructures();
        this.integrationManager.enableIntegrations();
        this.database = new Database(DatabaseDriver.SQLITE);
        try {
            this.database.init(this.getDataFolder());
            this.time = this.database.getSingletonNow(BreweryTimeDataType.INSTANCE);
        }
        catch (PersistenceException | IOException | SQLException e) {
            throw new RuntimeException(e);
        }
        this.drunksManager = new DrunksManagerImpl<Connection>(this.customDrunkEventRegistry, EventSection.events().enabledRandomEvents().stream().map(BreweryKey::parse).collect(Collectors.toSet()), () -> this.time, this.database, SqlDrunkStateDataType.INSTANCE, SqlDrunkenModifierDataType.INSTANCE);
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new BrewMigrationListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new BlockEventListener(this.structureRegistry, this.placedStructureRegistry, this.database, this.breweryRegistry), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerEventListener(this.placedStructureRegistry, this.breweryRegistry, this.database, this.drunksManager, this.drunkTextRegistry, this.recipeRegistry, this.drunkEventExecutor), (Plugin)this);
        pluginManager.registerEvents((Listener)new InventoryEventListener(this.breweryRegistry, this.database), (Plugin)this);
        this.worldEventListener = new WorldEventListener(this.database, this.placedStructureRegistry, this.breweryRegistry);
        this.worldEventListener.init();
        this.playerWalkListener = new PlayerWalkListener();
        pluginManager.registerEvents((Listener)this.worldEventListener, (Plugin)this);
        pluginManager.registerEvents((Listener)this.playerWalkListener, (Plugin)this);
        pluginManager.registerEvents((Listener)new EntityEventListener(), (Plugin)this);
        if (ClassUtil.exists("io.papermc.paper.event.connection.PlayerConnectionValidateLoginEvent")) {
            pluginManager.registerEvents((Listener)new PlayerJoinListener(), (Plugin)this);
        } else {
            pluginManager.registerEvents((Listener)new LegacyPlayerJoinListener(), (Plugin)this);
        }
        Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this, this::updateStructures, 1L, 1L);
        Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this, this::otherTicking, 1L, 1L);
        RecipeReader<ItemStack> recipeReader = new RecipeReader<ItemStack>(this.getDataFolder(), new BukkitRecipeResultReader(), BukkitIngredientManager.INSTANCE);
        recipeReader.readRecipes().forEach(recipeFuture -> recipeFuture.thenAcceptAsync(recipe -> this.recipeRegistry.registerRecipe((Recipe<ItemStack>)recipe)));
        DefaultRecipeReader.readDefaultRecipes(this.getDataFolder()).forEach((string, defaultRecipe) -> defaultRecipe.thenAcceptAsync(defaultRecipe1 -> this.recipeRegistry.registerDefaultRecipe((String)string, (DefaultRecipe<ItemStack>)defaultRecipe1)));
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, BreweryCommand::register);
        this.loadDrunkenReplacements();
        this.loadTimeFormats();
    }

    public void onDisable() {
        this.closeDatabase();
    }

    private void closeDatabase() {
        try {
            this.breweryRegistry.getOpened(StructureType.BARREL).forEach(barrel -> barrel.close(true));
            this.breweryRegistry.getOpened(StructureType.DISTILLERY).forEach(distillery -> distillery.close(true));
        }
        catch (Throwable e) {
            Logger.logErr(e);
        }
        try {
            this.database.setSingleton(BreweryTimeDataType.INSTANCE, Long.valueOf(this.time)).join();
            this.database.flush().join();
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
    }

    private void saveResources() {
        Stream.of("recipes.yml", "incomplete-recipes.yml", "locale/en-US.drunk_text.json", "locale/ru.drunk_text.json").forEach(this::saveResourceIfNotExists);
    }

    private void saveResourceIfNotExists(String resource) {
        if (new File(this.getDataFolder(), resource).exists()) {
            return;
        }
        super.saveResource(resource, false);
    }

    private void updateStructures(ScheduledTask ignored) {
        this.breweryRegistry.getActiveSinglePositionStructure().stream().filter(Tickable.class::isInstance).map(Tickable.class::cast).forEach(Tickable::tick);
        this.placedStructureRegistry.getStructures(StructureType.DISTILLERY).stream().map(MultiblockStructure::getHolder).map(Distillery.class::cast).forEach(Tickable::tick);
        List.copyOf(this.breweryRegistry.getOpened(StructureType.BARREL)).forEach(InventoryAccessible::tickInventory);
        List.copyOf(this.breweryRegistry.getOpened(StructureType.DISTILLERY)).forEach(InventoryAccessible::tickInventory);
    }

    private void otherTicking(ScheduledTask ignored) {
        this.drunksManager.tick(this.drunkEventExecutor::doDrunkEvent, uuid -> Bukkit.getPlayer((UUID)uuid) != null);
        try {
            if (++this.time % 200L == 0L) {
                this.database.setSingleton(BreweryTimeDataType.INSTANCE, Long.valueOf(this.time));
            }
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
    }

    public static NamespacedKey key(String key) {
        return new NamespacedKey("brewery", key);
    }

    @Generated
    public static TheBrewingProject getInstance() {
        return instance;
    }

    @Generated
    public StructureRegistry getStructureRegistry() {
        return this.structureRegistry;
    }

    @Override
    @Generated
    public PlacedStructureRegistryImpl getPlacedStructureRegistry() {
        return this.placedStructureRegistry;
    }

    @Generated
    public RecipeRegistryImpl<ItemStack> getRecipeRegistry() {
        return this.recipeRegistry;
    }

    @Generated
    public BreweryRegistry getBreweryRegistry() {
        return this.breweryRegistry;
    }

    @Generated
    public Database getDatabase() {
        return this.database;
    }

    @Generated
    public DrunkTextRegistry getDrunkTextRegistry() {
        return this.drunkTextRegistry;
    }

    @Generated
    public TimeFormatRegistry getTimeFormatRegistry() {
        return this.timeFormatRegistry;
    }

    @Override
    @Generated
    public DrunksManagerImpl<Connection> getDrunksManager() {
        return this.drunksManager;
    }

    @Generated
    public CustomEventRegistry getCustomDrunkEventRegistry() {
        return this.customDrunkEventRegistry;
    }

    @Generated
    public EventStepRegistry getEventStepRegistry() {
        return this.eventStepRegistry;
    }

    @Generated
    public DrunkEventExecutor getDrunkEventExecutor() {
        return this.drunkEventExecutor;
    }

    @Generated
    public long getTime() {
        return this.time;
    }

    @Override
    @Generated
    public BrewManager<ItemStack> getBrewManager() {
        return this.brewManager;
    }

    @Override
    @Generated
    public IntegrationManagerImpl getIntegrationManager() {
        return this.integrationManager;
    }

    @Generated
    public ActiveEventsRegistry getActiveEventsRegistry() {
        return this.activeEventsRegistry;
    }

    @Generated
    public PlayerWalkListener getPlayerWalkListener() {
        return this.playerWalkListener;
    }

    @Override
    @Generated
    public ModifierManager getModifierManager() {
        return this.modifierManager;
    }
}

