/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.effect;

import dev.jsinco.brewery.api.effect.modifier.DrunkenModifier;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.configuration.DrunkenModifierSection;
import dev.jsinco.brewery.database.PersistenceException;
import dev.jsinco.brewery.database.sql.SqlStatements;
import dev.jsinco.brewery.effect.DrunkenModifierDataType;
import dev.jsinco.brewery.util.DecoderEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class SqlDrunkenModifierDataType
implements DrunkenModifierDataType<Connection> {
    public static final SqlDrunkenModifierDataType INSTANCE = new SqlDrunkenModifierDataType();
    private final SqlStatements statements = new SqlStatements("/database/generic/modifiers");

    @Override
    public void insert(Pair<DrunkenModifierDataType.Data, Double> value, Connection connection) throws PersistenceException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.statements.get(SqlStatements.Type.INSERT));){
            preparedStatement.setBytes(1, DecoderEncoder.asBytes(value.first().playerUuid()));
            preparedStatement.setString(2, value.first().modifier().name());
            preparedStatement.setDouble(3, value.second());
            preparedStatement.execute();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void remove(DrunkenModifierDataType.Data toRemove, Connection connection) throws PersistenceException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.statements.get(SqlStatements.Type.DELETE));){
            preparedStatement.setBytes(1, DecoderEncoder.asBytes(toRemove.playerUuid()));
            preparedStatement.setString(2, toRemove.modifier().name());
            preparedStatement.execute();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public List<Pair<DrunkenModifier, Double>> find(UUID searchObject, Connection connection) throws PersistenceException {
        ArrayList<Pair<DrunkenModifier, Double>> arrayList;
        block9: {
            PreparedStatement preparedStatement = connection.prepareStatement(this.statements.get(SqlStatements.Type.FIND));
            try {
                preparedStatement.setBytes(1, DecoderEncoder.asBytes(searchObject));
                ResultSet query = preparedStatement.executeQuery();
                ArrayList<Pair<DrunkenModifier, Double>> modifiers = new ArrayList<Pair<DrunkenModifier, Double>>();
                while (query.next()) {
                    String modifierName = query.getString("modifier_name");
                    double value = query.getDouble("value");
                    DrunkenModifierSection.modifiers().drunkenModifiers().stream().filter(modifier -> modifier.name().equals(modifierName)).findAny().map(modifier -> new Pair<DrunkenModifier, Double>((DrunkenModifier)modifier, value)).ifPresent(modifiers::add);
                }
                arrayList = modifiers;
                if (preparedStatement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PersistenceException(e);
                }
            }
            preparedStatement.close();
        }
        return arrayList;
    }
}

