/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.structure;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import dev.jsinco.brewery.api.structure.StructureMeta;
import dev.jsinco.brewery.api.structure.StructureType;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.BreweryKeyed;
import dev.jsinco.brewery.api.util.BreweryRegistry;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.api.util.Pair;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class StructureJsonFormatValidator {
    private StructureJsonFormatValidator() {
        throw new IllegalStateException("Utility class");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validate(Path jsonPath) {
        try (InputStreamReader reader = new InputStreamReader(new BufferedInputStream(Files.newInputStream(jsonPath, new OpenOption[0])));){
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonElement jsonElement = jsonObject.get("meta");
            if (!(jsonElement instanceof JsonObject)) {
                boolean bl = false;
                return bl;
            }
            JsonObject metaJson = (JsonObject)jsonElement;
            String fileName = jsonPath.getFileName().toString();
            Map<StructureMeta<?>, Object> structureMeta = metaJson.entrySet().stream().map(entry -> {
                StructureMeta<?> meta = BreweryRegistry.STRUCTURE_META.get(BreweryKey.parse((String)entry.getKey()));
                if (meta == null) {
                    Logger.logErr("Unknown meta key in structure '" + fileName + "': " + (String)entry.getKey());
                    return null;
                }
                try {
                    return new Pair(meta, meta.deserializer().apply((JsonElement)entry.getValue()));
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::first, Pair::second));
            StructureType structureType = StructureJsonFormatValidator.get(structureMeta, StructureMeta.TYPE);
            if (structureType == null) {
                Logger.logErr("Missing meta key in structure '" + fileName + "': type");
                boolean bl = false;
                return bl;
            }
            for (StructureMeta<?> meta : structureType.mandatoryMeta()) {
                structureMeta.computeIfAbsent(meta, ignored -> meta.defaultValue());
            }
            JsonObject reformatedJson = new JsonObject();
            block16: for (Map.Entry<StructureMeta<?>, Object> entry2 : structureMeta.entrySet()) {
                Object value = entry2.getValue();
                String key = entry2.getKey().key().key();
                if (!entry2.getKey().validator().test(value)) {
                    Logger.logErr("Invalid value for meta type in structure '" + fileName + "':" + key);
                    value = entry2.getKey().defaultValue();
                }
                if (entry2.getKey().equals(StructureMeta.TYPE)) {
                    reformatedJson.add("type", (JsonElement)new JsonPrimitive(((BreweryKeyed)entry2.getValue()).key().key()));
                    continue;
                }
                if (Arrays.stream(structureType.mandatoryMeta()).noneMatch(entry2.getKey()::equals)) {
                    Logger.logErr("Illegal meta in structure '" + fileName + "': " + key);
                    continue;
                }
                Object object = value;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, Boolean.class, BreweryKeyed.class, String.class}, (Object)object, n)) {
                    case 0: {
                        Number number = (Number)object;
                        reformatedJson.add(key, (JsonElement)new JsonPrimitive(number));
                        continue block16;
                    }
                    case 1: {
                        Boolean bool = (Boolean)object;
                        reformatedJson.add(key, (JsonElement)new JsonPrimitive(bool));
                        continue block16;
                    }
                    case 2: {
                        BreweryKeyed breweryKeyed = (BreweryKeyed)object;
                        reformatedJson.add(key, (JsonElement)new JsonPrimitive(breweryKeyed.key().key()));
                        continue block16;
                    }
                    case 3: {
                        String string = (String)object;
                        reformatedJson.add(key, (JsonElement)new JsonPrimitive(string));
                        continue block16;
                    }
                }
                reformatedJson.add(key, metaJson.get(key));
            }
            jsonObject.add("meta", (JsonElement)reformatedJson);
            StructureJsonFormatValidator.dump((JsonElement)jsonObject, jsonPath);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Logger.logErr(e);
            return false;
        }
    }

    private static <T> T get(Map<StructureMeta<?>, Object> structureMeta, StructureMeta<T> meta) {
        return (T)structureMeta.get(meta);
    }

    public static void dump(JsonElement json, Path destinationFile) throws IOException {
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destinationFile.toFile(), false), StandardCharsets.UTF_8));){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            jsonWriter.setIndent("  ");
            gson.toJson(json, jsonWriter);
            writer.print("\n");
        }
    }
}

