/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration.serializers;

import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;

public class ConsumableSerializer
implements ObjectSerializer<Consumable> {
    @Override
    public boolean supports(@NonNull Class<? super Consumable> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return Consumable.class == type;
    }

    @Override
    public void serialize(@NonNull Consumable object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("type", object.type);
        eventData.putAll(object.modifiers);
        data.setValue(eventData);
    }

    @Override
    public Consumable deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        String type = data.get("type", String.class);
        return new Consumable(type, data.asMap().keySet().stream().filter(key -> !key.equals("type")).collect(Collectors.toUnmodifiableMap(key -> key, key -> data.get((String)key, Double.class))));
    }

    public record Consumable(String type, Map<String, Double> modifiers) {
    }
}

