/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.structure;

import dev.jsinco.brewery.api.breweries.StructureHolder;
import dev.jsinco.brewery.api.structure.MultiblockStructure;
import dev.jsinco.brewery.api.structure.PlacedStructureRegistry;
import dev.jsinco.brewery.api.structure.StructureType;
import dev.jsinco.brewery.api.vector.BreweryLocation;
import dev.jsinco.brewery.api.vector.BreweryVector;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

public class PlacedStructureRegistryImpl
implements PlacedStructureRegistry {
    private final Map<UUID, Map<BreweryVector, MultiblockStructure<? extends StructureHolder<?>>>> structures = new HashMap();
    private final Map<StructureType, Set<MultiblockStructure<?>>> typedMultiBlockStructureMap = new HashMap();

    @Override
    public void registerStructure(MultiblockStructure<?> multiblockStructure) {
        for (BreweryLocation location : multiblockStructure.positions()) {
            UUID worldUuid = location.worldUuid();
            this.structures.computeIfAbsent(worldUuid, ignored -> new HashMap()).put(location.toVector(), multiblockStructure);
        }
        this.typedMultiBlockStructureMap.computeIfAbsent(multiblockStructure.getHolder().getStructureType(), ignored -> new HashSet()).add(multiblockStructure);
    }

    @Override
    public void unregisterStructure(MultiblockStructure<?> structure) {
        for (BreweryLocation location : structure.positions()) {
            UUID worldUuid = location.worldUuid();
            this.structures.computeIfAbsent(worldUuid, ignored -> new HashMap()).remove(location.toVector());
        }
        this.typedMultiBlockStructureMap.computeIfAbsent(structure.getHolder().getStructureType(), ignored -> new HashSet()).remove(structure);
    }

    @Override
    public Optional<MultiblockStructure<?>> getStructure(BreweryLocation location) {
        UUID worldUuid = location.worldUuid();
        Map placedBreweryStructureMap = this.structures.getOrDefault(worldUuid, new HashMap());
        return Optional.ofNullable((MultiblockStructure)placedBreweryStructureMap.get(location.toVector()));
    }

    @Override
    public Set<MultiblockStructure<?>> getStructures(Collection<BreweryLocation> locations) {
        HashSet breweryStructures = new HashSet();
        for (BreweryLocation location : locations) {
            this.getStructure(location).ifPresent(breweryStructures::add);
        }
        return breweryStructures;
    }

    public Set<MultiblockStructure<?>> getStructures(StructureType structureType) {
        return this.typedMultiBlockStructureMap.computeIfAbsent(structureType, ignored -> new HashSet());
    }

    @Override
    public Optional<StructureHolder<?>> getHolder(BreweryLocation location) {
        UUID worldUuid = location.worldUuid();
        Map placedBreweryStructureMap = this.structures.getOrDefault(worldUuid, new HashMap());
        return Optional.ofNullable((MultiblockStructure)placedBreweryStructureMap.get(location.toVector())).map(MultiblockStructure::getHolder);
    }

    @Override
    public void unloadWorld(UUID worldUuid) {
        Map<BreweryVector, MultiblockStructure<StructureHolder<?>>> removed = this.structures.remove(worldUuid);
        if (removed == null) {
            return;
        }
        removed.forEach((ignored1, structure) -> this.typedMultiBlockStructureMap.computeIfAbsent(structure.getHolder().getStructureType(), ignored2 -> new HashSet()).remove(structure));
    }

    @Override
    public void clear() {
        this.structures.clear();
    }
}

