/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import org.joml.Matrix3d;

public class DecoderEncoder {
    private static final int SEGMENT_BITS = 127;
    private static final int CONTINUE_BIT = 128;
    private static final byte LIST_ENCODING_VERSION = 0;

    private DecoderEncoder() {
        throw new IllegalStateException("Utility class");
    }

    public static void encode(byte[][] byteArrayArray, OutputStream outputStream) throws IOException {
        outputStream.write(0);
        DecoderEncoder.writeVarInt(byteArrayArray.length, outputStream);
        for (byte[] byteArray : byteArrayArray) {
            DecoderEncoder.writeVarInt(byteArray.length, outputStream);
            outputStream.write(byteArray);
        }
    }

    public static byte[][] decode(InputStream inputStream) throws IOException {
        byte version = (byte)inputStream.read();
        if (version != 0) {
            throw new IOException("Invalid format");
        }
        int listSize = DecoderEncoder.readVarInt(inputStream);
        byte[][] output = new byte[listSize][];
        for (int i = 0; i < listSize; ++i) {
            int stringLength = DecoderEncoder.readVarInt(inputStream);
            output[i] = inputStream.readNBytes(stringLength);
        }
        return output;
    }

    public static int readVarInt(InputStream inputStream) throws IOException {
        int value;
        block1: {
            value = 0;
            int position = 0;
            do {
                byte currentByte = (byte)inputStream.read();
                value |= (currentByte & 0x7F) << position;
                if ((currentByte & 0x80) == 0) break block1;
            } while ((position += 7) < 32);
            throw new IOException("VarInt is too big");
        }
        return value;
    }

    public static void writeVarInt(int value, OutputStream outputStream) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                outputStream.write(value);
                return;
            }
            outputStream.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static String serializeTransformation(Matrix3d matrix3d) {
        double[] doubles = matrix3d.get(new double[9]);
        JsonArray output = new JsonArray();
        for (double aDouble : doubles) {
            output.add((Number)aDouble);
        }
        return output.toString();
    }

    public static Matrix3d deserializeTransformation(String matrixString) {
        JsonArray jsonElement = JsonParser.parseString((String)matrixString).getAsJsonArray();
        List jsonElementList = jsonElement.asList();
        double[] m = new double[9];
        for (int i = 0; i < jsonElementList.size(); ++i) {
            m[i] = ((JsonElement)jsonElementList.get(i)).getAsDouble();
        }
        return new Matrix3d(m[0], m[1], m[2], m[3], m[4], m[5], m[6], m[7], m[8]);
    }

    public static UUID asUuid(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        long firstLong = bb.getLong();
        long secondLong = bb.getLong();
        return new UUID(firstLong, secondLong);
    }

    public static byte[] asBytes(UUID uuid) {
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }
}

