/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import dev.jsinco.brewery.ingredient.Ingredient;
import dev.jsinco.brewery.ingredient.IngredientManager;
import dev.jsinco.brewery.ingredient.ScoredIngredient;
import dev.jsinco.brewery.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BrewingStepUtil {
    public static double nearbyValueScore(long expected, long value) {
        double diff = Math.abs(expected - value);
        return 1.0 - Math.max(diff / (double)expected, 0.0);
    }

    public static double getIngredientsScore(Map<Ingredient, Integer> target, Map<Ingredient, Integer> actual) {
        List<Pair> customScores = actual.entrySet().stream().filter(entry -> entry.getKey() instanceof ScoredIngredient).map(entry -> new Pair<Double, Integer>(((ScoredIngredient)entry.getKey()).score(), (Integer)entry.getValue())).toList();
        Pair<Double, Integer> scoredIngredientPair = customScores.stream().reduce(new Pair<Double, Integer>(1.0, 1), (pair1, pair2) -> new Pair<Double, Integer>((Double)pair1.first() * Math.pow((Double)pair2.first(), ((Integer)pair2.second()).intValue()), (Integer)pair1.second() + (Integer)pair2.second()));
        double output = Math.pow(scoredIngredientPair.first(), 1.0 / (double)scoredIngredientPair.second().intValue());
        Map<Ingredient, Integer> modifiedTarget = BrewingStepUtil.compressIngredients(target);
        Map<Ingredient, Integer> modifiedActual = BrewingStepUtil.compressIngredients(actual);
        if (modifiedTarget.size() != modifiedActual.size()) {
            return 0.0;
        }
        for (Map.Entry<Ingredient, Integer> targetEntry : modifiedTarget.entrySet()) {
            Integer actualAmount = modifiedActual.get(targetEntry.getKey());
            if (actualAmount == null || actualAmount == 0) {
                return 0.0;
            }
            output *= BrewingStepUtil.nearbyValueScore(targetEntry.getValue().intValue(), actualAmount.intValue());
        }
        return output;
    }

    private static Map<Ingredient, Integer> compressIngredients(Map<Ingredient, Integer> ingredients) {
        HashMap<Ingredient, Integer> output = new HashMap<Ingredient, Integer>();
        ingredients.entrySet().stream().map(entry -> {
            Object patt0$temp = entry.getKey();
            if (patt0$temp instanceof ScoredIngredient) {
                ScoredIngredient scoredIngredient = (ScoredIngredient)patt0$temp;
                return new Pair<Ingredient, Integer>(scoredIngredient.baseIngredient(), (Integer)entry.getValue());
            }
            return new Pair<Ingredient, Integer>((Ingredient)entry.getKey(), (Integer)entry.getValue());
        }).forEach(pair -> IngredientManager.insertIngredientIntoMap(output, pair));
        return output;
    }
}

