/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.breweries;

import dev.jsinco.brewery.util.BreweryKey;
import dev.jsinco.brewery.util.BreweryKeyed;
import dev.jsinco.brewery.util.Registry;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public enum CauldronType implements BreweryKeyed
{
    WATER("minecraft:water_cauldron"),
    LAVA("minecraft:lava_cauldron"),
    SNOW("minecraft:powder_snow_cauldron");

    private String materialKey;

    private CauldronType(String materialKey) {
        this.materialKey = materialKey;
    }

    public String materialKey() {
        return this.materialKey;
    }

    @Override
    public BreweryKey key() {
        return BreweryKey.parse(this.name().toLowerCase(Locale.ROOT));
    }

    @Nullable
    public static CauldronType from(String materialType) {
        for (CauldronType cauldronType : Registry.CAULDRON_TYPE.values()) {
            if (!cauldronType.materialKey().equals(materialType)) continue;
            return cauldronType;
        }
        return null;
    }
}

