/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.breweries.distillery;

import dev.jsinco.brewery.brew.Brew;
import dev.jsinco.brewery.brew.BrewingStep;
import dev.jsinco.brewery.brew.DistillStepImpl;
import dev.jsinco.brewery.breweries.Distillery;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.brew.BrewAdapter;
import dev.jsinco.brewery.bukkit.breweries.BrewInventory;
import dev.jsinco.brewery.bukkit.breweries.distillery.BukkitDistilleryDataType;
import dev.jsinco.brewery.bukkit.breweries.distillery.DistilleryBrewPersistenceHandler;
import dev.jsinco.brewery.bukkit.structure.PlacedBreweryStructure;
import dev.jsinco.brewery.bukkit.util.BlockUtil;
import dev.jsinco.brewery.bukkit.util.BukkitAdapter;
import dev.jsinco.brewery.bukkit.util.SoundPlayer;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.configuration.locale.TranslationsConfig;
import dev.jsinco.brewery.database.PersistenceException;
import dev.jsinco.brewery.structure.StructureMeta;
import dev.jsinco.brewery.util.Logger;
import dev.jsinco.brewery.util.MessageUtil;
import dev.jsinco.brewery.util.Pair;
import dev.jsinco.brewery.vector.BreweryLocation;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BukkitDistillery
implements Distillery<BukkitDistillery, ItemStack, Inventory> {
    private final PlacedBreweryStructure<BukkitDistillery> structure;
    private long startTime;
    private final BrewInventory mixture;
    private final BrewInventory distillate;
    private boolean dirty = true;
    private final Set<BreweryLocation> mixtureContainerLocations = new HashSet<BreweryLocation>();
    private final Set<BreweryLocation> distillateContainerLocations = new HashSet<BreweryLocation>();
    private long recentlyAccessed = -1L;

    public BukkitDistillery(@NotNull PlacedBreweryStructure<BukkitDistillery> structure) {
        this(structure, TheBrewingProject.getInstance().getTime());
    }

    public BukkitDistillery(@NotNull PlacedBreweryStructure<BukkitDistillery> structure, long startTime) {
        this.structure = structure;
        this.startTime = startTime;
        BreweryLocation unique = structure.getUnique();
        this.mixture = new BrewInventory("Distillery Mixture", structure.getStructure().getMeta(StructureMeta.INVENTORY_SIZE), new DistilleryBrewPersistenceHandler(unique, false));
        this.distillate = new BrewInventory("Distillery Distillate", structure.getStructure().getMeta(StructureMeta.INVENTORY_SIZE), new DistilleryBrewPersistenceHandler(unique, true));
    }

    @Override
    public boolean open(@NotNull BreweryLocation location, @NotNull UUID playerUuid) {
        this.checkDirty();
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (this.mixtureContainerLocations.contains(location)) {
            this.playInteractionEffects(location, player);
            return this.openInventory(this.mixture, player);
        }
        if (this.distillateContainerLocations.contains(location)) {
            this.playInteractionEffects(location, player);
            return this.openInventory(this.distillate, player);
        }
        return false;
    }

    @Override
    public void close(boolean silent) {
        Stream.of(this.mixture, this.distillate).forEach(inventory -> {
            inventory.updateBrewsFromInventory();
            inventory.getInventory().clear();
        });
    }

    private void playInteractionEffects(BreweryLocation location, Player player) {
        BukkitAdapter.toWorld(location).ifPresent(world -> SoundPlayer.playSoundEffect(Config.config().sounds().distilleryAccess(), Sound.Source.BLOCK, world, (double)location.x() + 0.5, (double)location.y() + 0.5, (double)location.z() + 0.5));
        BlockUtil.playWobbleEffect(location, player);
    }

    private boolean openInventory(BrewInventory inventory, Player player) {
        if (!player.hasPermission("brewery.distillery.access")) {
            MessageUtil.message((Audience)player, TranslationsConfig.DISTILLERY_ACCESS_DENIED, new TagResolver[0]);
            return false;
        }
        if (this.inventoryUnpopulated()) {
            this.mixture.updateInventoryFromBrews();
            this.distillate.updateInventoryFromBrews();
        }
        this.recentlyAccessed = TheBrewingProject.getInstance().getTime();
        TheBrewingProject.getInstance().getBreweryRegistry().registerOpened(this);
        player.openInventory(inventory.getInventory());
        return true;
    }

    @Override
    public boolean inventoryAllows(@NotNull UUID playerUuid, @NotNull ItemStack item) {
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (player == null) {
            return false;
        }
        if (!player.hasPermission("brewery.distillery.access")) {
            MessageUtil.message((Audience)player, TranslationsConfig.DISTILLERY_ACCESS_DENIED, new TagResolver[0]);
            return false;
        }
        return this.inventoryAllows(item);
    }

    @Override
    public boolean inventoryAllows(@NotNull ItemStack item) {
        return BrewAdapter.fromItem(item).isPresent();
    }

    @Override
    public Set<Inventory> getInventories() {
        return Set.of(this.mixture.getInventory(), this.distillate.getInventory());
    }

    private void checkDirty() {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        HashSet<BreweryLocation> potLocations = new HashSet<BreweryLocation>();
        Material taggedMaterial = Material.valueOf((String)this.structure.getStructure().getMeta(StructureMeta.TAGGED_MATERIAL).toUpperCase(Locale.ROOT));
        for (BreweryLocation location : this.structure.positions()) {
            Block block = BukkitAdapter.toBlock(location);
            if (taggedMaterial != block.getType()) continue;
            potLocations.add(location);
        }
        for (BreweryLocation breweryLocation : potLocations) {
            if (potLocations.contains(breweryLocation.add(0, 1, 0)) || potLocations.contains(breweryLocation.add(0, -1, 0))) {
                this.mixtureContainerLocations.add(breweryLocation);
                continue;
            }
            this.distillateContainerLocations.add(breweryLocation);
        }
    }

    private boolean inventoryUnpopulated() {
        return this.recentlyAccessed == -1L || this.recentlyAccessed + 20L <= TheBrewingProject.getInstance().getTime();
    }

    @Override
    public void tick() {
        BreweryLocation unique = ((PlacedBreweryStructure)this.getStructure()).getUnique();
        long timeProcessed = this.getTimeProcessed();
        long processTime = this.getProcessTime();
        int processedBrews = (int)(timeProcessed / processTime * (long)((PlacedBreweryStructure)this.getStructure()).getStructure().getMeta(StructureMeta.PROCESS_AMOUNT).intValue());
        if (!BlockUtil.isChunkLoaded(unique) || this.mixture.brewAmount() < processedBrews || this.distillate.isFull()) {
            return;
        }
        this.checkDirty();
        if (timeProcessed % processTime == 0L && timeProcessed != 0L) {
            BukkitAdapter.toWorld(unique).ifPresent(world -> SoundPlayer.playSoundEffect(Config.config().sounds().distilleryProcess(), Sound.Source.BLOCK, world, (double)unique.x() + 0.5, (double)unique.y() + 0.5, (double)unique.z() + 0.5));
        }
        if (timeProcessed % (processTime / 4L) < processTime / 16L && this.mixture.brewAmount() > processedBrews) {
            this.distillateContainerLocations.stream().map(BukkitAdapter::toLocation).map(location -> location.add(0.5, 1.3, 0.5)).forEach(location -> location.getWorld().spawnParticle(Particle.ENTITY_EFFECT, location, 2, (Object)Color.WHITE));
        }
    }

    @Override
    public void tickInventory() {
        long processTime;
        long timeProcessed;
        this.checkDirty();
        if (this.inventoryUnpopulated()) {
            this.close(false);
            TheBrewingProject.getInstance().getBreweryRegistry().unregisterOpened(this);
            return;
        }
        if (!this.mixture.getInventory().getViewers().isEmpty() || !this.distillate.getInventory().getViewers().isEmpty()) {
            this.recentlyAccessed = TheBrewingProject.getInstance().getTime();
        }
        if ((timeProcessed = this.getTimeProcessed()) < (processTime = this.getProcessTime()) - 1L || this.mixture.getInventory().isEmpty()) {
            return;
        }
        boolean hasChanged = this.mixture.updateBrewsFromInventory();
        this.distillate.updateBrewsFromInventory();
        if (hasChanged) {
            this.resetStartTime();
            return;
        }
        if (timeProcessed < processTime) {
            return;
        }
        this.transferItems(this.mixture, this.distillate, (int)((long)((PlacedBreweryStructure)this.getStructure()).getStructure().getMeta(StructureMeta.PROCESS_AMOUNT).intValue() * (timeProcessed / processTime)));
        this.distillate.updateInventoryFromBrews();
        this.mixture.updateInventoryFromBrews();
        this.resetStartTime();
    }

    @Override
    public Optional<Inventory> access(@NotNull BreweryLocation breweryLocation) {
        if (this.inventoryUnpopulated() && (this.mixtureContainerLocations.contains(breweryLocation) || this.distillateContainerLocations.contains(breweryLocation))) {
            this.mixture.updateInventoryFromBrews();
            this.distillate.updateInventoryFromBrews();
            TheBrewingProject.getInstance().getBreweryRegistry().registerOpened(this);
        }
        this.recentlyAccessed = TheBrewingProject.getInstance().getTime();
        if (this.mixtureContainerLocations.contains(breweryLocation)) {
            return Optional.of(this.mixture.getInventory());
        }
        if (this.distillateContainerLocations.contains(breweryLocation)) {
            return Optional.of(this.distillate.getInventory());
        }
        return Optional.empty();
    }

    private long getTimeProcessed() {
        return TheBrewingProject.getInstance().getTime() - this.startTime;
    }

    private void resetStartTime() {
        this.startTime = TheBrewingProject.getInstance().getTime();
        try {
            TheBrewingProject.getInstance().getDatabase().updateValue(BukkitDistilleryDataType.INSTANCE, this);
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
    }

    private long getProcessTime() {
        return ((PlacedBreweryStructure)this.getStructure()).getStructure().getMeta(StructureMeta.PROCESS_TIME);
    }

    private void transferItems(BrewInventory inventory1, BrewInventory inventory2, int amount) {
        int i;
        LinkedList<Pair<Brew, Integer>> brewsToTransfer = new LinkedList<Pair<Brew, Integer>>();
        for (i = 0; i < inventory1.getBrews().length; ++i) {
            if (inventory1.getBrews()[i] == null) continue;
            if (amount-- <= 0) break;
            brewsToTransfer.add(new Pair<Brew, Integer>(inventory1.getBrews()[i], i));
        }
        for (i = 0; i < inventory2.getBrews().length; ++i) {
            if (inventory2.getBrews()[i] != null) continue;
            if (brewsToTransfer.isEmpty()) {
                return;
            }
            Pair nextBrewToTransfer = (Pair)brewsToTransfer.poll();
            Brew mixtureBrew = (Brew)nextBrewToTransfer.first();
            inventory1.store(null, (Integer)nextBrewToTransfer.second());
            inventory2.store(mixtureBrew.withLastStep(BrewingStep.Distill.class, BrewingStep.Distill::incrementAmount, () -> new DistillStepImpl(1)), i);
        }
    }

    @Override
    public void destroy(BreweryLocation breweryLocation) {
        Location location = BukkitAdapter.toLocation(breweryLocation).add(0.5, 0.0, 0.5);
        for (BrewInventory distilleryInventory : List.of(this.distillate, this.mixture)) {
            List.copyOf(distilleryInventory.getInventory().getViewers()).forEach(HumanEntity::closeInventory);
            distilleryInventory.getInventory().clear();
            for (Brew brew : distilleryInventory.getBrews()) {
                if (brew == null) continue;
                location.getWorld().dropItem(location, BrewAdapter.toItem(brew, new Brew.State.Other()));
            }
        }
    }

    @Override
    @Generated
    public PlacedBreweryStructure<BukkitDistillery> getStructure() {
        return this.structure;
    }

    @Override
    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public BrewInventory getMixture() {
        return this.mixture;
    }

    @Generated
    public BrewInventory getDistillate() {
        return this.distillate;
    }
}

