/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.effect.event;

import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.effect.named.ChickenNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.DrunkMessageNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.DrunkenWalkNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.FeverNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.HallucinationNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.KaboomNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.NauseaNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.PassOutNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.PukeNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.StumbleNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.TeleportNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.step.ApplyPotionEffectExecutable;
import dev.jsinco.brewery.bukkit.effect.step.ConditionalWaitStepExecutable;
import dev.jsinco.brewery.bukkit.effect.step.ConsumeStepExecutable;
import dev.jsinco.brewery.bukkit.effect.step.CustomEventExecutable;
import dev.jsinco.brewery.bukkit.effect.step.SendCommandExecutable;
import dev.jsinco.brewery.bukkit.effect.step.TeleportExecutable;
import dev.jsinco.brewery.bukkit.effect.step.WaitStepExecutable;
import dev.jsinco.brewery.event.CustomEvent;
import dev.jsinco.brewery.event.CustomEventRegistry;
import dev.jsinco.brewery.event.DrunkEvent;
import dev.jsinco.brewery.event.EventPropertyExecutable;
import dev.jsinco.brewery.event.EventStep;
import dev.jsinco.brewery.event.EventStepRegistry;
import dev.jsinco.brewery.event.NamedDrunkEvent;
import dev.jsinco.brewery.event.step.ApplyPotionEffect;
import dev.jsinco.brewery.event.step.ConditionalWaitStep;
import dev.jsinco.brewery.event.step.ConsumeStep;
import dev.jsinco.brewery.event.step.CustomEventStep;
import dev.jsinco.brewery.event.step.SendCommand;
import dev.jsinco.brewery.event.step.Teleport;
import dev.jsinco.brewery.event.step.WaitStep;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DrunkEventExecutor {
    private final Map<UUID, List<EventStep>> onJoinExecutions = new HashMap<UUID, List<EventStep>>();

    public DrunkEventExecutor() {
        EventStepRegistry registry = TheBrewingProject.getInstance().getEventStepRegistry();
        registry.register(NamedDrunkEvent.fromKey("chicken"), ChickenNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("drunken_walk"), DrunkenWalkNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("drunk_message"), DrunkMessageNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("fever"), FeverNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("hallucination"), HallucinationNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("kaboom"), KaboomNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("nausea"), NauseaNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("pass_out"), PassOutNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("puke"), PukeNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("stumble"), StumbleNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("teleport"), TeleportNamedExecutable::new);
        registry.register(ApplyPotionEffect.class, stepProperty -> new ApplyPotionEffectExecutable(stepProperty.potionEffectName(), stepProperty.amplifierBounds(), stepProperty.durationBounds()));
        registry.register(ConditionalWaitStep.class, stepProperty -> new ConditionalWaitStepExecutable(stepProperty.getCondition()));
        registry.register(ConsumeStep.class, stepProperty -> new ConsumeStepExecutable(stepProperty.alcohol(), stepProperty.toxins()));
        registry.register(SendCommand.class, stepProperty -> new SendCommandExecutable(stepProperty.command(), stepProperty.senderType()));
        registry.register(Teleport.class, stepProperty -> new TeleportExecutable(stepProperty.location()));
        registry.register(WaitStep.class, stepProperty -> new WaitStepExecutable(stepProperty.durationTicks()));
        CustomEventRegistry eventRegistry = TheBrewingProject.getInstance().getCustomDrunkEventRegistry();
        registry.register(CustomEventStep.class, stepProperty -> new CustomEventExecutable(eventRegistry.getCustomEvent(stepProperty.customEventKey()).getSteps()));
    }

    public void doDrunkEvent(UUID playerUuid, DrunkEvent event) {
        if (event instanceof NamedDrunkEvent) {
            NamedDrunkEvent namedDrunkEvent = (NamedDrunkEvent)event;
            this.doDrunkEvents(playerUuid, List.of(new EventStep.Builder().addProperty(namedDrunkEvent).build()));
        } else if (event instanceof CustomEvent.Keyed) {
            CustomEvent.Keyed customEvent = (CustomEvent.Keyed)event;
            this.doDrunkEvents(playerUuid, customEvent.getSteps());
        }
    }

    public void doDrunkEvents(UUID playerUuid, List<? extends EventStep> events) {
        EventStepRegistry registry = TheBrewingProject.getInstance().getEventStepRegistry();
        for (int i = 0; i < events.size(); ++i) {
            EventStep event = events.get(i);
            List<EventPropertyExecutable> properties = event.properties().stream().map(registry::toExecutable).sorted(Comparator.comparing(EventPropertyExecutable::priority, Integer::compareTo)).toList();
            for (EventPropertyExecutable eventPropertyExecutable : properties) {
                if (eventPropertyExecutable.execute(playerUuid, events, i) != EventPropertyExecutable.ExecutionResult.STOP_EXECUTION) continue;
                return;
            }
        }
    }

    public void add(UUID playerUuid, List<EventStep> events) {
        this.onJoinExecutions.put(playerUuid, events);
    }

    public void clear(UUID playerUuid) {
        this.onJoinExecutions.remove(playerUuid);
    }

    public void clear() {
        this.onJoinExecutions.clear();
    }

    public void onPlayerJoin(UUID playerUuid) {
        List<EventStep> eventStepList = this.onJoinExecutions.remove(playerUuid);
        if (eventStepList == null) {
            return;
        }
        this.doDrunkEvents(playerUuid, eventStepList);
    }
}

