/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.effect.step;

import dev.jsinco.brewery.event.EventPropertyExecutable;
import dev.jsinco.brewery.event.EventStep;
import dev.jsinco.brewery.event.step.SendCommand;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SendCommandExecutable
implements EventPropertyExecutable {
    private final String command;
    private final SendCommand.CommandSenderType senderType;

    public SendCommandExecutable(String command, SendCommand.CommandSenderType senderType) {
        this.command = command;
        this.senderType = senderType;
    }

    @Override
    @NotNull
    public EventPropertyExecutable.ExecutionResult execute(UUID contextPlayer, List<? extends EventStep> events, int index) {
        Player player = Bukkit.getPlayer((UUID)contextPlayer);
        if (player == null) {
            return EventPropertyExecutable.ExecutionResult.CONTINUE;
        }
        String command = this.command.replace("@player_name@", player.getName());
        switch (this.senderType) {
            case PLAYER: {
                player.performCommand(command);
                break;
            }
            case SERVER: {
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command);
            }
        }
        return EventPropertyExecutable.ExecutionResult.CONTINUE;
    }

    @Override
    public int priority() {
        return 4;
    }
}

